#include <stdio.h>
#include <assert.h>
#include <stdlib.h>

/* Deklaracija asemblerske funkcije */
void diff(float * x, float * y, int n, float * r);

int main()
{
  float *x, *y; /* Pokazivaci na nizove realnih brojeva */
  int n;         /* Duzina nizova */
  float r;      /* Rezultat */
  int i;         /* Brojac u petljama */

  /* Ucitavamo duzinu nizova */
  assert(scanf("%d", &n) == 1);
   
  /* Alociramo prostor za nizove */
  assert((x = malloc(sizeof(float) * n)) != NULL);
  assert((y = malloc(sizeof(float) * n)) != NULL);

  /* Unosimo elemente prvog niza */
  for(i = 0; i < n; i++)
    assert(scanf("%f", &x[i]) == 1);

  /* Unosimo elemente drugog niza */
  for(i = 0; i < n; i++)
    assert(scanf("%f", &y[i]) == 1);
  
  /* Pozivamo funkciju */
  diff(x, y, n, &r);

  /* Stampamo rezultat */
  printf("%g\n", r);
  
  /* Oslobadjamo prostor za nizove */
  free(x);
  free(y);

  return EXIT_SUCCESS;
}
