.intel_syntax noprefix

.data
	
mask: .int 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff
	
.text 
.global diff
#############################################################################
##
## Funkcija:
##
## void diff(float * x, float * y, int n, float * r);
##
## racuna sumu sum_{0..n-1}|x[i] - y[i]|, koristeci paralelne SSE
## instrukcije. Argumenti funkcije su:
## 
## -- float * x --  [ebp+8]  -- adresa prvog niza
## -- float * y --  [ebp+12] -- adresa drugog niza
## -- int n     --  [ebp+16] -- duzina nizova
## -- float * r --  [ebp+20] -- adresa na koju treba smestiti rezultat
##
############################################################################ 
diff:
	## Prolog funkcije
	enter 0,0
	push esi
	push edi
	
        ## Proverava se da li procesor podrzava SSE instrukcije.
        mov     eax, 1
        cpuid
        test    edx, 0x2000000
        jz not_supported

        ## Cuva se sadrzaj SSE registara (i registara koprocesora).
        mov     edx, esp
        and     esp, 0xfffffff0
        sub     esp, 512
        fxsave  [esp]

	## U registar ecx smestamo duzinu nizova n
	mov ecx, [ebp + 16]

	## U registar esi smestamo adresu prvog, a u edi drugog niza
	mov esi, [ebp + 8]
	mov edi, [ebp + 12]

	## U registru xmm2 cemo cuvati cetiri parcijalne sume
	xorps xmm2, xmm2

	## U registru xmm7 cemo cuvati masku za racunanje apsolutne
	## vrednosti.
	movups xmm7, mask

	
next_four:
	## Ako je ostalo bar jos cetiri sabirka
	cmp ecx, 4
	jb next_one

	## Ucitavamo sledeca cetiri para brojeva
	movups xmm0, [esi]
	add esi, 16
	movups xmm1, [edi]
	add edi, 16

	## Oduzimamo ih i racunamo apsolutnu vrednost
	subps xmm0, xmm1
	andps xmm0, xmm7

	## Dodajemo na parcijalne sume
	addps xmm2, xmm0

	## Umanjujemo brojac i prelazimo na sledecu iteraciju
	sub ecx, 4
	jmp next_four

next_one:
	## Ako nema vise elemenata...
	jecxz last

	## Dodajemo pojedinacne preostale elemente na najnizu
	## paricjalnu sumu.
	movss xmm0, [esi]
	add esi, 4
	movss xmm1, [edi]
	add edi, 4
	subss xmm0, xmm1
	andps xmm0, xmm7
	addss xmm2, xmm0

	dec ecx
	jmp next_one
	
last:
	
	## Sabiramo dve parcijalne sume
	movhlps xmm0, xmm2
	addss xmm2, xmm0
	movaps xmm0, xmm2
	shufps xmm0, xmm0, 0b01010101
	addss xmm2, xmm0
	
	## Upisujemo rezultat u za to predvidjenu lokaciju
	mov esi, [ebp + 20]
	movss [esi], xmm2
	
        ## Vraca se prethodni sadrzaj u registre koprocesora i SSE
	## registre.
        fxrstor [esp]
        mov     esp, edx

	## Epilog funkcije.
	pop edi
	pop esi
	leave
	ret

not_supported:
	## Ako SSE instrukcije nisu podrzane, prekidamo program exit(1)
	## pozivom. 
	mov eax, 1
	mov ebx, 1
	int 0x80
	
