.intel_syntax noprefix

.data
ten: .int 10
	
.text
.global compact

##########################################################################
##
## Funkcija:
##
## void compact(char * s, char * p);
##
## eliminise visestruka uzastopna ponavljanja jednakih karaktera u
## niski s, i rezultat smesta u nisku p.
## Argumenti funkcije su:
##
## -- char * s  -- [ebp+8]  -- adresa ulaznog stringa
## -- char * p  -- [ebp+12] -- adresa niza u koji treba upisati rezultat
##
###########################################################################
compact:
        ## Prolog funkcije.
        enter   0, 4
        push    esi
        push    edi

	## U registar esi smestamo adresu stringa.
	mov esi, [ebp + 8]

	## U registar edi smestamo adresu rezultujuceg stringa.
	mov edi, [ebp + 12]
	
	## Postavljamo smer kretanja kroz string
	cld

	## Registar ah ce cuvati prethodni karakter. Inicijalizujemo ga
	## nulom, kako bi poredjenje radilo i u prvoj iteraciji.
		
next_char:
	## Ucitavamo sledeci karakter
	lodsb

	## Da li smo dosli do kraja stringa?
	cmp al, 0
	je last_char
	
	## Proveravamo da li je tekuci karakter jednak sa prethodnim.
	## Ako jeste, ne radimo nista.
	cmp al, ah
	je continue

	## Ako nije, tada upisujemo karakter u izlazni string i pamtimo ga
	## kao prethodni karakter, za sledece iteracije.
not_equal:	
	mov ah, al
	stosb

continue:
	## Prelazimo na sledeci karakter.
	jmp next_char
last_char:	

	## Upisujemo terminirajucu nulu u izlazni string.
	stosb	
done:	
	## Epilog funkcije
	pop edi
	pop esi
	leave
	ret
	