﻿using Microsoft.AspNet.Identity.EntityFramework;

namespace SocialNetwork.Models
{
    public enum Gender { Female, Male };

    // You can add profile data for the user by adding more properties to your ApplicationUser class, please visit http://go.microsoft.com/fwlink/?LinkID=317594 to learn more.
    public class ApplicationUser : IdentityUser
    {
        public string FirstName { set; get; }
        public string LastName { set; get; }

        public Gender Gender { set; get; }

        public int YearOfBirth { set; get; }

    }

    public class ApplicationDbContext : IdentityDbContext<ApplicationUser>
    {
        public ApplicationDbContext()
            : base("DefaultConnection")
        {
        }
    }
}