﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Microsoft.AspNet.Identity;
using Microsoft.AspNet.Identity.EntityFramework;
using Microsoft.Owin.Security;
using SocialNetwork.Models;

namespace SocialNetwork.Controllers
{
    [Authorize]
    public class UserController : Controller
    {

        public ApplicationUser CurrentUser
        {
            get
            {
                UserManager<ApplicationUser> manager = new UserManager<ApplicationUser>(new UserStore<ApplicationUser>(new ApplicationDbContext()));
                ApplicationUser user = manager.FindByName(User.Identity.Name);
                return user;
            }
        }
        //
        // GET: /User/
        public ActionResult Profile(string id)
        {
            if (id != null && id != "")
            {
                UserManager<ApplicationUser> manager = new UserManager<ApplicationUser>(new UserStore<ApplicationUser>(new ApplicationDbContext()));
                ApplicationUser user = manager.FindById(id);
                if (user != null)
                {
                    return View(user);
                }
                else
                {
                    return RedirectToAction("Error", new { Message = "Unknown user", RedirectAction = "Index", RedirectController = "Home" });
                }
            }
            else
                return View(CurrentUser);
            
           
        }

        public ActionResult List()
        {
            UserListViewModel model = new UserListViewModel();
            model.Gender = "all";
            return View(model);
        }

        [HttpPost]
        public ActionResult List(UserListViewModel model)
        {           
            return PartialView("_PartialList", model);
        }

        public ActionResult Error(string Message, string RedirectAction, string RedirectController)
        {
            ViewBag.Message = Message;
            ViewBag.Action = RedirectAction;
            ViewBag.Controller = RedirectController;
            return View("~/Views/Shared/Error.cshtml");
        }
	}
}