.intel_syntax noprefix
	
.text
.global count_primes

##########################################################################
##
## Funkcija:
##
## int count_primes(int a, int b);
##
## odredjuje koliko ima prostih brojeva u intervalu [a,b] (1 < a <= b). 
## Argumenti funkcije su:
##
## -- int a -- [ebp + 8] -- donja granica intervala.
## -- int b -- [ebp + 12] -- gornja granica intervala.
###########################################################################
count_primes:
        ## Prolog funkcije.
	enter 0,0
	push esi
	push edi
	push ebx

	## Registar esi inicijalizujemo na donju, a edi na gornju granicu
	## datog intervala. Registrom esi cemo iterirati kroz interval.
	mov esi, [ebp + 8]
	mov edi, [ebp + 12]

	## Registar ebx inicijalizujemo na 0. On ce nam biti brojac prostih
	## brojeva.
	xor ebx, ebx
	
next_number:
	## Izlazak iz petlje kada je esi > edi
	cmp esi, edi
	jg last_number

	## Pozivamo funkciju is_prime za tekucu vrednost brojaca esi.
	push esi
	call is_prime
	add esp, 4

	## Ako je broj prost, uvecavamo brojac ebx za 1.
	add ebx, eax

	## Prelazimo na sledeci broj iz intervala.
	inc esi
	jmp next_number
last_number:	

	## Kopiramo vrednost brojaca u eax.
	mov eax, ebx
	
	## Epilog funkcije
	pop ebx
	pop edi
	pop esi
	leave
	ret


##
## Pomocna funkcija:
##
## int is_prime(int x)
##
## ispituje da li je dati broj x prost. Funkcija vraca 1 ako jeste,
## a 0 u suprotnom. Argument funkcije je:
##
## -- int x -- [ebp + 8] -- broj za koji ispitujemo da li je prost.
##
is_prime:
	## Prolog funkcije
	enter 0,0
	push ebx
	
	## U ebx ucitavamo vrednost broja x.
	mov ebx, [ebp + 8]

	## Registar ecx ce sadrzati tekuci broj k za koji ispitujemo da li
	## deli broj x (inicijalno k = 2).
	mov ecx, 2
	
next_divisor:
	## Ako je k * k > x, tada izlazimo iz petlje (broj x je prost)
	mov eax, ecx
	mul ecx
	cmp eax, ebx
	jg last_divisor

	## U suprotnom odredjujemo x % k
	mov eax, ebx
	xor edx, edx
	div ecx

	## Ako je x % k == 0, tada broj x nije prost.
	cmp edx, 0
	je not_prime

	## U suprotnom, uvecavamo k i prelazimo na sledecu iteraciju.
	inc ecx
	jmp next_divisor
last_divisor:

	## AKo nema delilaca broja x, tada je broj prost (vracamo 1).
	mov eax, 1
	jmp done
	
not_prime:
	## U suprotnom, vracamo 0.
	mov eax, 0

done:	
	## Epilog funkcije
	pop ebx
	leave
	ret
	