.text
.align 2


.global untouchable

@ Funkcija:
@
@ int untouchable(int x);
@
@ ispituje da li je broj x>0 nedodirljiv. Broj je nedodirljiv ako ne 
@ postoji prirodan broj n takav da je zbir njegovih pravih delilaca 
@ jednak x. Funkcija vraca 0 ako je broj nedodirljiv, a u 
@ suprotnom vraca najmanji broj n koji zadovoljava navedeno svojstvo.
@ Argument funkcije je:
@
@ r0 -- int x
@	
untouchable:
	@ Prolog funkcije
	stmfd sp!, {fp, lr}
	mov fp, sp

	@ Cuvamo na steku vrednosti registara koje cemo koristiti.
	stmfd sp!, {r4-r6}

	@ IDEJA ALGORITMA: Moze se pokazati da ako je x != 1 i ako je
	@ n takav da je zbir njegovih pravih delilaca jednak x, tada
	@ je n < x^2. Otuda je dovoljno ispitati za sve brojeve
	@ 2 <= n < x^2 da li je zbir njihovih pravih delilaca jednak x.
	@ Ako nije, broj je nedodirljiv.

	@ U r4 smestamo broj x
	mov r4, r0

	@ Slucaj jedinice: vracamo broj 2 (jer je jedini pravi delilac
	@ dvojke upravo 1).
	cmp r4, #1
	beq one

	@  U suprotnom, racunamo x^2 i smestamo ga u r5.
	mov r1, r4
	mul r5, r1, r4
	
	@ U registar r6 smestamo tekuce n (inicijalno 2).
	mov r6, #2

next:
	@ Dokle god je n < x^2
	cmp r6, r5
	beq last

	@ Izracunava se suma pravih delilaca broja n.
	mov r0, r6
	bl sum_of_divisors
	
	@ Ako je suma pravih delilaca broja n jednaka x, tada
	@ broj nije nedodirljiv. Vracamo broj n. 
	cmp r0, r4
	beq found

	@ U suprotnom prelazimo na sledeci broj n.
	add r6, r6, #1
	b next
last:

	@ Ako nije pronadjen broj n sa opisanim svojstvom, vracamo 0
	@ (broj je nedodirljiv).
	mov r0, #0
	b done

	
found:
	@ Vraca se broj n sa opisanim svojstvom.
	mov r0, r6
	b done

one:
	@ U slucaju x == 1, vracamo 2.
	mov r0, #2
	b done


done:
	@ Vracamo vrednosti registara koje smo koristili.
	ldmfd sp!, {r4-r6}
	
	@ Epilog funkcije
	mov sp, fp
	ldmfd sp!, {fp, pc}


@
@ Funkcija:
@
@   int sum_of_divisors(int n);
@
@ izracunava sumu pravih delilaca broja n.
@ Argument funkcije je:
@
@  -- r0 -- int n
@
sum_of_divisors:

	@ Prolog funkcije
	stmfd sp!, {fp, lr}
	mov fp, sp

	@ Cuvamo na steku vrednosti registara koje cemo koristiti.
	stmfd sp!, {r4-r7}
	
	@ U registar r4 ucitavamo broj n.
	mov r4, r0

	@ Pravi delioci broja n su manji ili jednaki broju [n/2]. 
	@ Zato je dovoljno ici do ovog broja.
	mov r5, r4, asr #1
	
	@ Registar r6 ce biti brojac k (inicijalno 1). 
	mov r6, #1

	@ Registar r7 ce cuvati sumu.
	mov r7, #0

next_num:
	@ Dokle god je k <= [n/2]
	cmp r6, r5
	bgt last_num	

	@ Izracunavamo n % k
	mov r0, r4
	mov r1, r6
	bl __modsi3
	
	@ Ispitujemo da li k deli n i dodajemo ga na sumu ako je to 
	@ tacno.
	cmp r0, #0
	addeq r7, r6
	
	@ Uvecavamo k i prelazimo na sledecu iteraciju.
	add r6, r6, #1
	b next_num
last_num:

	@ Vracamo sumu delilaca.
	mov r0, r7

	@ Vracamo vrednosti registara koje smo koristili.
	ldmfd sp!, {r4-r7}

	@ Epilog funkcije
	mov sp, fp
	ldmfd sp!, {fp, pc}
