.intel_syntax noprefix

.data
ten: .int 10
	
.text
.global digits

##########################################################################
##
## Funkcija:
##
## void digits(int n, int *l, int *g);
##
## odredjuje najmanju i najvecu cifru dekadnog zapisa pozitivnog broja n.	
## Argumenti funkcije su:
##
## -- int n  -- [ebp+8]  -- dati broj
## -- int *l  -- [ebp+12] -- adresa na koju treba upisati najmanju cifru
## -- int *g  -- [ebp+16] -- adresa na koju treba upisati najvecu cifru
##
###########################################################################
digits:
        ## Prolog funkcije.
        enter   0, 0
        push    ebx
        push    esi
        push    edi

	## Ucitavamo broj n u eax.
	mov eax, [ebp + 8]

	## Registar esi ce cuvati najmanju nadjenu cifru, a registar edi
	## najvecu cifru broja n.
	xor esi, esi
	xor edi, edi

	## Ako je n == 0, preskacemo petlju.
	cmp eax, 0
	je last

	## U suprotnom inicijalizujemo najmanju cifru na 9. Svaki put kada se
	## naidje na neku manju cifru, ova vrednost ce biti azurirana. Najveca
	## cifra ostaje 0 i svaki put kada naidjemo na vecu cifru, ova
	## vrednost ce biti azurirana.
	mov esi, 9

	## Petlja:
next:
	## Delimo broj n sa 10. Nakon deljenja se sledeca izdvojena cifra
	## nalazi u registru edx.
	xor edx, edx
	div dword ptr ten

	## Ako je tekuca cifra manja od do sada najmanje (registar esi), tada
	## se azurira registar esi.
check_lower:	
	cmp edx, esi
	jb found_lower
	jmp check_greater
found_lower:
	mov esi, edx

	## Ako je tekuca cifra veca od do sada najvece (registar edi), tada
	## se azurira registar edi.
check_greater:	
	cmp edx, edi
	ja found_greater
	jmp continue
found_greater:
	mov edi, edx

continue:
	## Ako je nakon deljenja kolicnik 0, znaci da nema vise cifara. U
	## suprotnom, idemo na sledecu iteraciju.
	cmp eax,0
	ja next
last:	

	## Upisujemo najmanju cifru u za to predvidjenu lokaciju.
	mov eax, [ebp+12]
	mov [eax], esi

	## Upisujemo najvecu cifru u za to predvidjenu lokaciju.
	mov eax, [ebp+16]
	mov [eax], edi

done:	
	## Epilog funkcije
	pop edi
	pop esi
	pop ebx
	leave
	ret
	