#include <stdio.h>

/* PROGRAM DEMONSTRIRA FUNKCIJE ZA RAD SA OZNACENIM BROJEVIMA U
   BINARNOJ OSNOVI (TIP INT) */

/* NAJPRE NAVODIMO NEKE FUNKCIJE SA PRETHODNIH CASOVA KOJE CEMO
   KORISTITI */

/* Funkcija izdvaja iz podatka x bit na poziciji i (pozicije se broje sa desna
   u levo pocev od 0), i smesta ga u najnizi bit podatka na koji pokazuje b.
   Ostali bitovi rezultujuceg podatka se postavljaju na 0. */
void procitaj_bit(unsigned x, int i, unsigned * b)
{
  *b = (x >> i) & 1;
}

/* Funkcija postavlja bit na poziciji i u podatku na koji pokazuje x na 
   vrednost najnizeg bita u podatku b */
void postavi_bit(unsigned * x, int i, unsigned b)
{
  *x = (b << i) | (*x & ~(1 << i));
}

/* Funkcija simulira POLUSABIRAC, tj. kolo koje sabira dva bita ne uzimajuci
   u obzir prethodni prenos. Vrednosti bitova koji se sabiraju nalaze se
   u najnizim bitovima podataka x i y, vrednost zbira se smesta u najnizi
   bit podatka na koji pokazuje S, dok se vrednost prenosa smesta u najnizi
   bit podatka na koji pokazuje C. */
void polusabirac(unsigned x, unsigned y, unsigned * S, unsigned * C)
{
  *S = x ^ y;
  *C = x & y;
}

/* Funkcija simulira POTPUNI SABIRAC, tj. kolo koje sabira dva bita uzimajuci
   u obzir prethodni prenos. Parametri su kao i u prethodnoj funkciji, uz
   dodatni parametar pc ciji najnizi bit cuva vrednost prethodnog prenosa */
void potpuni_sabirac(unsigned x, unsigned y, unsigned pc,
		     unsigned * S, unsigned * C)
{
  unsigned S1, C1, C2;
  
  
  polusabirac(x, y, &S1, &C1);
  polusabirac(S1, pc, S, &C2);
  *C = C1 | C2;
}

/* Funkcija vrsi sabiranje dva neoznacena cela broja x i y ne koristeci
   operator +, simulacijom algoritma sabiranja koji se obavlja u hardveru.
   Vrednost zbira se smesta na lokaciju na koju pokazuje S. Ukoliko
   je prilikom sabiranja nastupilo prekoracenje, podatak na koji pokazuje
   C postavlja se na 1, a u suprotnom na 0 */
void saberi_neoznacene(unsigned x, unsigned y, unsigned * S, unsigned * C)
{
  int i;
  unsigned bx, by;
  unsigned bs, bc, pc = 0;
  
  
  for(i = 0; i < 32; i++)
    {
      /* Ucitavamo i-te bitove podataka x i y. */
      procitaj_bit(x, i, &bx);
      procitaj_bit(y, i, &by);

      /* Sabiramo bitove, uz uvazavanje prethodnog prenosa */
      potpuni_sabirac(bx, by, pc, &bs, &bc);

      /* Postavljamo i-ti bit rezultata, a dobijeni prenos cuvamo za sledecu
	 iteraciju */
      postavi_bit(S, i, bs);
      pc = bc;
    }
  
  /* Zavrsni prenos je ujedno i indikator prekoracenja */
  *C = pc;
  
}

/* Funkcija implementira POLUODUZIMAC (bez uzimanja u obzir prethodne
   pozajmice) */
void poluoduzimac(unsigned x, unsigned y, unsigned * S, unsigned * C)
{
  *S = x ^ y;
  *C = (x ^ 1) & y;
}

/* Funkcija implementira POTPUNI ODUZIMAC (uz uzimanje u obzir prethodne
   pozajmice) */
void potpuni_oduzimac(unsigned x, unsigned y, unsigned pc,
		      unsigned * S, unsigned * C)
{
  unsigned S1, C1, C2;
  
  
  poluoduzimac(x, y, &S1, &C1);
  poluoduzimac(S1, pc, S, &C2);
  *C = C1 | C2;
}

/* Funkcija oduzima dva neoznacena cela broja x i y bez koriscenja operatora
   -, simulirajuci algoritam oduzimanja koji se koristi u hardveru. */
void oduzmi_neoznacene(unsigned x, unsigned y, unsigned * S, unsigned * C)
{
  int i;
  unsigned bx, by;
  unsigned bs, bc, pc = 0;
  
  
  for(i = 0; i < 32; i++)
    {

      /* Citmo i-ti bit u podacima x i y */
      procitaj_bit(x, i, &bx);
      procitaj_bit(y, i, &by);

      /* Oduzimamo bitove uzimajuci u obzir prethodnu pozajmicu */
      potpuni_oduzimac(bx, by, pc, &bs, &bc);

      /* Smestamo dobijenu razliku na poziciju i u rezultatu. */
      postavi_bit(S, i, bs);

      /* Nova pozajmica postaje prethodna pozajmica, za sledecu iteraciju */
      pc = bc;
    }
  
  *C = pc;
}

/* Funkcija izracunava -x za dati oznaceni ceo broj x. Rezultat se smesta 
   na adresu na koju pokazuje R */
void promeni_znak(int x, int * R)
{
  unsigned C;
  x = ~x;
  saberi_neoznacene(x, 1, R, &C);
}


/* Funkcija ispituje da li je broj x >= 0 */
int pozitivan(int x)
{
  return (x & 0x80000000) == 0;
}

/* Funkcija ispituje da li je broj x < 0 */
int negativan(int x)
{
  return (x & 0x80000000) != 0;
}

/* Funkcija sabira dva oznacena cela broja x i y. Rezultat smesta na 
   adresu na koju pokazuje S, dok se informacija o prekoracenju smesta
   na lokaciju na koju pokazuje C */
void saberi_oznacene(int x, int y, int * S, int * C)
{
  unsigned C1;
  saberi_neoznacene(x, y, S, &C1);
  *C = (pozitivan(x) && pozitivan(y) && negativan(*S))
    ||
    (negativan(x) && negativan(y) && pozitivan(*S));
}

/* Funkcija oduzima oznacene brojeve x i y. Oduzimanje se vrsi svodjenjem
   na oduzimanje neoznacenih celih brojeva, slicno kao i kod sabiranja. */
void oduzmi_oznacene(int x, int y, int * S, int * C)
{
  unsigned C1;
  oduzmi_neoznacene(x, y, S, &C1);
  *C = (pozitivan(x) && negativan(y) && negativan(*S)) ||
    (negativan(x) && pozitivan(y) && pozitivan(*S));
}

int main()
{
  int x,y, s, c;
  int p, q;

  scanf("%d %d", &x, &y);
  
  saberi_oznacene(x, y, &s, &c);  
  printf("Zbir: %d\tPrekoracenje: %d\n", s, c);
  
  oduzmi_oznacene(x, y, &s, &c);  
  printf("Razlika: %d\tPrekoracenje: %d\n", s, c);
  
  return 0;
}
