.intel_syntax noprefix

.data
ten:	.int 10
	
.text

.global niz_cifara

# Funkcija:
#
# int niz_cifara(unsigned x, unsigned * cifre) ;
#
# odredjuje dekadne cifre broja x i upisuje ih u niz na koji
# pokazuje cifre. Cifre se upisuju pocev od cifre najvece
# tezine. Funkcija vraca duzinu kreiranog niza (tj. broj dekadnih cifara)
# Argumenti funkcije su:
#
# -- unsigned x -- [ebp + 8] -- dati broj
# -- unsigned * cifre -- [ebp + 12] -- adresa niza u koji se upisuju cifre
#
niz_cifara:
	enter 0,0
	push ebx

	# Registar eax ce sadrzati broj x, a registar ebx adresu
	# rezultujuceg niza.
	mov eax, [ebp + 8]
	mov ebx, [ebp + 12]

	## C-algoritam:
	#
	#  k = 0;
	#  do {
	#  
	#    cifre[k++] = x % 10;
	#    x /= 10;
	#  while (x != 0);
	#
	# obrni_niz(cifre, k);
	# return k;
 	
	xor ecx, ecx   # k = 0
sledeca_cifra:
	# Deljenje
	xor edx, edx   
	div dword ptr ten        

	# Upis u element niza i uvecavanje indeksa k 
	mov [ebx + 4 * ecx], edx
	inc ecx

	# Uporedjivanje x sa nulom nakon deljenja i izlazak ako je jednako
	cmp eax, 0
	je poslednja_cifra

	# Prelazak na sledecu iteraciju
	jmp sledeca_cifra
poslednja_cifra:	

	# Cuvamo ecx na steku, jer ce ga mozda pozvana funkcija promeniti
	push ecx
	
	# Poziv funkcije obrni_niz(cifre, k)
	push ecx
	push ebx
	call obrni_niz
	add esp, 8

	# Skidamo ecx sa steka
	pop ecx
	
	# Vracamo k (ecx)
	mov eax, ecx
	
	pop ebx
	leave
	ret
	
