.intel_syntax noprefix


.text
.global mocan

###########################################################################
##
## Funkcija ispituje da li je dati prirodan broj x mocan. Broj x je mocan
## ako za svaki prost broj p koji deli x, broj p^2 takodje deli x. Funkcija
## vraca 1 ako je broj mocan, u suprotnom vraca 0.
##	
## int mocan(int x);
##
## -- int x -- [ebp+8] -- broj za koji se ispituje da li je mocan.
##########################################################################

mocan:
	## Prolog funkcije
	enter 0,0
	push edi
	push ebx

	## Ideja algoritma: neka je broj x = p1^e1 * p2^e2 * ... * pk^ek
	## gde su p1, p2, ..., pk prosti cinioci broja x, a e1, e2, ..., ek
	## visestrukosti ovih prostih cinilaca u faktorizaciji broja x. Neka
	## je p1 < p2 < ... < pk. Tada je najmanji delilac (razlicit od 1)
	## broja x upravo p1. Zato cemo u petlji traziti prvi delilac broja
	## x pocev od 2. Kada ga pronadjemo, to je upravo p1. Zatim cemo
	## deliti x dokle god mozemo sa p1 (i brojacemo koliko puta mozemo
	## -- to je upravo e1). Nakon toga, ako je e1 == 1, tada broj nije
	## mocan. U suprotnom imamo da je x sada jednako  p2^e2 * ... * pk^ek,
	## pa je najmanji sledeci delilac broja x sada p2. Kada ga pronadjemo,
	## ponavljamo isti postupak kao za p1. Ovaj proces se nastavlja dokle
	## god ne obradimo sve proste cinioce, tj. dok ne bude x == 1, ili
	## dok ne pronadjemo prost cinilac visestrukosti 1.

	## Registar ebx ce nam sadrzati tekucu vrednost broja x.
	mov ebx, [ebp+8]

	## Registar edi cemo uvecavati u petlji dok ne pronadjemo prvi broj
	## kojim je deljiv broj x. 
	mov edi, 1
		
sledeci_faktor:
	## Ako je tekuca vrednost broja x jednaka 1, tada je broj mocan.
	cmp ebx, 1
	je uspeh

	## Ispitujemo za sledeci broj da li je delilac broja x.
	inc edi

	## Registar ecx cemo koristiti za brojanje visestrukosti prostog
	## cinioca broja x.
	xor ecx, ecx

sledeci:
	## Delimo x sa tekucom vrednoscu registra edi.
	mov eax, ebx
	xor edx, edx
	div edi

	## Ako je x deljivo sa edi, tada smo pronasli sledeci prost cinilac
	## broja x. U sledecim iteracijama unutrasnje petlje cemo izbrojati
	## visestrukost ovog cinioca.
	cmp edx, 0
	jne pripremi_sledeci

	## Azuriramo x i uvecavamo visestrukost tekuceg cinioca.
	mov ebx, eax
	inc ecx
	jmp sledeci

pripremi_sledeci:
	## Ako je visestrukost tekuceg cinioca 1, tada broj nije mocan.
	cmp ecx,1
	je neuspeh

	## U suprotnom prelazimo na sledeci prost cinilac.
	jmp sledeci_faktor

neuspeh:
	## U slucaju neuspeha vracamo 0.
	xor eax, eax
	jmp kraj

uspeh:
	## U slucaju uspeha vracamo 1.
	mov eax, 1
	
kraj:	
	## Epilog funkcije
	pop ebx
	pop edi
	leave
	ret
	
