.intel_syntax noprefix

.text

.global binom

##
## int binom(int n, int k)
##
## Funkcija izracunava binomni koeficient (n k), gde je
## 0 <= k <= n. Argumenti funkcije:
##
## int n -- [ebp + 8]
## int k -- [ebp + 12]
binom:

	## Prolog funkcije
	enter 0,0
	push esi
	push edi
	push ebx

	## NAPOMENA: Binomni koeficient se racuna po rekurentnoj formuli
	## (n k) = (n - 1   k) + (n - 1   k - 1). Drugim recima, ovde
	## imamo dva rekurzivna poziva cije povratne vrednosti treba
	## sabrati. Izlaz iz rekurzije je (n 0) = (n n) = 1.
	
	## Smestamo n u esi a k u edi. Primetimo da je jako bitno da ove
	## vrednosti smestimo u registre koji pripadaju pozivajucoj funkciji
	## jer ce nam one biti potrebne i nakon prvog rekurzivnog poziva
	## (koji moze pokvariti vrednosti u registrima koji pripadaju
	## pozvanoj funkciji).
	mov esi, [ebp + 8]
	mov edi, [ebp + 12]

	## Ako je k == 0, tada izlazimo iz rekurzije.
	cmp edi, 0
	je izlaz_rekurzija

	## Ako je k == n, tada izlazimo iz rekurzije.
	cmp edi, esi
	je izlaz_rekurzija

	## Prvi rekurzivni poziv binom(n - 1, k).
	## Postavljamo k na stek, a zatim umanjujemo esi (sada sadrzi n - 1)
	## i postavljamo ga na stek. Zatim pozivamo funkciju i skidamo
	## argumente sa steka.
	push edi
	dec esi
	push esi
	call binom
	add esp, 8

	## Premestamo povratnu vrednost prvog rekurzivnog poziva (iz registra
	## eax) u registar ebx. Registar ebx takodje pripada pozivajucoj
	## funkciji, pa ga drugi rekurzivni poziv nece pokvariti.
	mov ebx, eax

	## Pozivamo rekurzivni poziv binom(n - 1, k - 1).
	## Umanjujemo edi (sada sadrzi k - 1) i postavljamo ga na stek.
	## Postavljamo esi (n - 1) na stek, pozivamo funkciju i skidamo
	## argumente sa steka.
	dec edi
	push edi
	push esi
	call binom
	add esp, 8

	## Dodajemo na povratnu vrednost drugog poziva sacuvanu povratnu
	## vrednost prvog poziva, cime dobijamo trazeni binomni koeficient
	## u registru eax.
	add eax, ebx
	jmp kraj
	

izlaz_rekurzija:
	## Izlaz iz rekurzije -- vracamo 1.
	mov eax, 1
	
kraj:	
	## Epilog funkcije
	pop ebx
	pop edi
	pop esi
	leave
	ret
	
