.intel_syntax noprefix

.text
.global suma_niza

##
## int suma_niza(int * a, int n)
##
## Funkcija sumira elemente celobrojnog niza na ciji prvi element
## pokazuje pokazivac a, a cija je duzina n. Argumenti funkcije:
##
## -- int *a -- [ebp + 8] -- pokazivac na pocetak niza
## -- int n -- [ebp + 12] -- duzina niza
##
## Funkcija vraca izracunatu sumu elemenata niza.
##
suma_niza:
	## Prolog funkcije
	enter 0,0
	push esi
	
	## NAPOMENA: Pokazivaci su 32-bitni podaci, bez obzira na koji
	## tip podatka pokazuju. Zato argument pokazivackog tipa na
	## steku uvek zauzima 4 bajta.

	## NAPOMENA: Osim navodjenja labele, memorijski operandi se mogu
	## zadavati i na slozeniji nacin, prema formuli:
	##
	##            bazna_adresa + faktor * indeks + pomeraj 
	##
	## gde je bazna adresa uvek sadrzana u nekom registru (bazni registar)
	## faktor je broj 1, 2, 4 ili 8 (ako se ne navede, podrazumeva se 1)
	## indeks je broj sadrzan uvek u nekom registru (indeksni registar),
	## dok je pomeraj konstanta.
	## Ovako zadat memorijski operand se uvek u instrukciji navodi u
	## okviru velikih zagrada [], na primer [esi + 4 * ecx + 12], gde
	## je esi bazni registar (sadrzi baznu adresu), ecx je indeksni
	## registar (sadrzi tekuci indeks), faktor skaliranja je 4, a pomeraj
	## je 12 bajtova. 
	## Svaka od komponenti se moze izostaviti, cime se dobijaju razliciti
	## oblici adresiranja:
	##
	##  -- ako se navede samo bazna adresa, tada je u pitanju tzv. bazno
	## adresiranje. Npr. [esi] ili [ebx]. U ovom slucaju se za operand
	## uzima podatak koji se u memoriji nalazi na adresi koju sadrzi
	## dati bazni registar. Ovo je ekvivalentno dereferenciranju
	## pokazivaca u  C-u (imamo pokazivac u registru, a uzimamo ono na
	## sta on pokazuje u memoriji).
	##
	## -- ako se navede bazna adresa i indeks (uz eventualni faktor
	## skaliranja) tada je u pitanju tzv. indeksno adresiranje. Npr.,
	## [esi + 4 * ecx], [edi + 8 * eax], [ebx + ecx]. Prvi registar
	## je bazni (sadrzi baznu adresu) dok je drugi indeksni. Ovaj nacin
	## adresiranja je zgodan kod rada sa nizovima -- u bazni registar
	## se upise adresa pocetka niza, dok se u indeksni registar upise
	## brojac (koji se azurira u svakoj iteraciji). Faktor skaliranja
	## je po pravilu jednak velicini elemenata niza (npr. ako su elementi
	## int-ovi (4 bajta), tada ce faktor skaliranja biti 4).
	##
	## -- ako se navede samo bazni registar i pomeraj, tada je u pitanju
	## bazno adresiranje sa pomerajem. Ovo se cesto koristi za pristup
	## elementima na steku, relativno u odnosu na neku poziciju, tipicno
	## poziciju pocetka tekuceg okvira steka, npr [ebp + 8], [ebp + 12]
	## i sl.
	
	
	## NAPOMENA: Kao sto znamo, u C-u se sa nizovima uvek barata preko
	## pokazivaca na njihov prvi element (samo ime niza se tako ponasa
	## u C-u). Zato se funkciji nikada ne prenosi niz, vec uvek pokazivac
	## na njegov pocetak. Postoje dva nacina da se pristupa elementima
	## niza: prvi je pomocu indeksa (u C-u a[i] znaci *(a+i), dok u
	## asembleru koristimo indeksno adresiranje npr. [esi + 4*ecx])
	## a drugi je pomocu pokazivaca koji se krece kroz elemente niza
	## (u C-u p = a, a zatim *p++ u svakoj iteraciji, u asembleru
	## cemo prosto uvecavati registar koji sadrzi adresu za 4 u svakoj
	## iteraciji, i koristiti bazno adresiranje). U ovom primeru
	## koristimo indeksnu sintaksu.
	
	## Registar esi ce cuvati adresu pocetka niza.
	mov esi, [ebp + 8]
	
	## Registar ecx cemo koristiti kao brojac (indeks). Inicijalno
	## je 0.
	xor ecx, ecx

	## NAPOMENA: xor ecx, ecx je ekvivalentno sa mov ecx, 0 zato sto
	## se ekskluzivnom disjunkcijom istih bitova uvek dobija 0, pa
	## ce rezultat xor-ovanja registra sa samim sobom biti sve nule,
	## tj. vrednost 0. Medjutim, varijanta sa xor instrukcijom je
	## nesto efikasnija od ekvivalentne mov instrukcije zato sto ima
	## dva registarska operanda, koji se krace kodiraju nego neposredni
	## operand 0 (koji se zapisuje kao 32-bitna konstanta u masinskoj
	## instrukciji).

	## Registar eax ce sadrzati sumu. Inicijalno je 0.
	xor eax, eax

	## Registar edx ce sadrzati n.
	mov edx, [ebp + 12]

sledeci_element:
	## Dokle god je indeks manji od n...
	cmp ecx, edx
	jae poslednji_element

	
	## Dodajemo na sumu element niza sa indeksom ecx. Koristimo indeksno
	## adresiranje memorijskog operanda, gde je bazna adresa u esi
	## (adresa pocetka niza) a indeks u ecx. Faktor skaliranja je 4,
	## zato sto su elementi niza velicine 4 bajta.
	add eax, [esi + 4 * ecx]
	
	## Uvecavamo indeks i prelazimo na sledecu iteraciju.
	inc ecx	
	jmp sledeci_element
poslednji_element:

	## U registru eax je sada povratna vrednost.

	## Epilog funkcije
	pop esi
	leave
	ret
	
