.intel_syntax noprefix


.text

.global savrsen_stepen

# Funkcija ispituje da li je n savrsen stepen, tj. da li se
# moze napisati u obliku m^k, gde je k > 1. Vraca 1 ako jeste,
# u kom slucaju vraca i m i k preko pokazivaca. Vraca 0 ako
# nije savrsen stepen.
#
# int savrsen_stepen(unsigned n, unsigned * m, unsigned * k)
#
# -- unsigned n -- ebp + 8
# -- unsigned * m -- ebp + 12
# -- unsigned * k -- ebp + 16
savrsen_stepen:
	enter 0,0
	push esi
	push edi
	push ebx

	mov esi, [ebp + 8]   # n
	mov ebx, 1           # m          
	mov edi, 2           # k

	## Jedinica je specijalni slucaj, moze se napisati kao 1^2.
	cmp esi, 1
	je uspeh

	## U suprotnom, pocinjemo od dvojke
	mov ebx, 2           # m

sledece_m:
	## Dokle god je m^2 <= n
	mov eax, ebx
	mul ebx
	cmp eax, esi	
	ja poslednje_m

	## Sa k pocinjemo od 2.
	mov edi, 2           # k = 2
	mov eax, ebx         # m^1 = m^(k-1) je u eax
sledece_k:

	# U ovom trenutku je u eax m^(k-1). Nakon mnozenja
	# sa m imacemo m^k u eax registru. Na ovaj nacin
	# racunamo m^k efikasnije, nego u prethodnoj verziji,
	# gde smo svaki put pozivali pomocnu funkciju m^k
	# koja je iznova racunala ovu vrednost u k iteracija.
	# Ovako samo prethodni rezultat m^(k-1) domnozimo sa
	# m i dobijamo m^k u jednom koraku. 
	mul ebx
	
	## Ako je m^k > n, zavrsavamo unutrasnju petlju
	cmp eax, esi
	ja poslednje_k

	## Ako je m^k == n, tada smo pronasli trazene m i k
	je uspeh
	
	## U suprotnom, uvecavamo k i prelazimo na sledecu iteraciju
	inc edi
	jmp sledece_k
poslednje_k:	

	## Prelazimo na sledece m
	inc ebx
	jmp sledece_m
poslednje_m:

	## Ako nisu pronadjeni m i k, tada vracamo 0
	mov eax, 0
	jmp kraj

uspeh:
	## Ako su pronadjeni m i k, tada ih upisujemo na
	## date adrese i vracamo 1
	mov eax, [ebp + 12]
	mov [eax], ebx
	mov eax, [ebp + 16]
	mov [eax], edi
	mov eax, 1	
kraj:	
	pop ebx
	pop edi
	pop esi
	leave
	ret


