.intel_syntax noprefix


.text
.global niz_max_min


##
## void niz_max_min(int * a, int n, int * max, int * min)
##
## izracunava maksimalni i minimalni element niza. Argumenti
## funkcije:
##
## -- int * a -- [ebp + 8] -- adresa pocetnog elementa niza
## -- int n   -- [ebp + 12] -- broj elemenata niza
## -- int * max -- [ebp + 16] -- adresa lokacije na koju treba upisati
##				 vrednost najveceg elementa.
## -- int * min -- [ebp + 20] -- adresa lokacije na koju treba upisati
##                               vrednost najmanjeg elementa
##
niz_max_min:

	## Prolog funkcije
	enter 0,0
	push esi
	push edi
	push ebx

	## Registar esi cemo koristiti kao pokazivac koji se krece kroz
	## elemente niza. Inicijalno ga postavljamo na adresu pocetnog
	## elementa niza.
	mov esi, [ebp + 8]

	## Registar ecx ce biti brojac. Inicijalno se postavlja na vrednost
	## n, a zatim ce se u svakoj iteraciji umanjivati, dok se ne spusti
	## na 0.
	mov ecx, [ebp + 12]

	## Registar ebx cemo koristiti za cuvanje maksimuma. Inicijalno ga
	## postavljamo na vrednost pocetnog elementa (koristimo bazno
	## adresiranje, jer se u esi nalazi adresa pocetnog elementa)
	mov ebx, [esi]

	## Registar edi cemo koristiti za cuvanje minimuma. Slicno kao i kod
	## maksimuma, postavljamo ga na pocetni element.
	mov edi, [esi]

	dec ecx      # n--
	add esi, 4   # p++
	
sledeci_element: 
	## Dokle god je n > 0...
	cmp ecx, 0
	je poslednji_element

	## Ucitavamo u eax element na koji pokazuje esi (bazno adresiranje)
	mov eax, [esi]

	## Uporedjujemo ucitani element sa najvecim. 
	cmp eax, ebx
	jg pronadjen_veci

	## Ako tekuci nije veci od najveceg, onda ga uporedjujemo sa najmanjim.
	cmp eax, edi
	jl pronadjen_manji
	
	jmp preskoci

pronadjen_veci:
	## Ako je tekuci element veci od najveceg, tada aziruramo ebx.
	mov ebx, eax
	jmp preskoci

pronadjen_manji:
	## Ako je tekuci element manji od najmanjeg, tada azuriramo edi.
	mov edi, eax
	
preskoci:
	## Uvecavamo pokazivac i umanjujemo brojac, a zatim prelazimo na
	## sledecu iteraciju. VAZNA NAPOMENA: Pokazivacka aritmetika u
	## asembleru nije tako pametna kao u C-u. Pokazivaci su u asembleru
	## samo nenegativni brojevi i nista vise. Ne postoji nacin da
	## asembler zna velicinu podatka na koji pokazivac pokazuje, pa
	## samim tim ne postoji nacin da asembler automatski odredi za
	## koliko bajtova treba uvecati adresu. Zbog toga programer mora
	## sam da uveca pokazivac za odgovarajuci broj bajtova. U nasem
	## slucaju uvecavamo esi za 4, znajuci da su int-ovi cetiri bajta.
	add esi, 4
	dec ecx
	jmp sledeci_element
poslednji_element:

	## Cuvamo maksimalnu vrednost na za to predvidjenu lokaciju. Prva
	## instrukcija ucitava parameter funkcije max (pokazivac) u registar
	## esi. Sada kada imamo adresu lokacije u registru esi, u drugoj
	## instrukciji baznim adresiranjem premestamo vrednost registra ebx
	## na adresu na koju pokazuje esi.
	mov esi, [ebp + 16]
	mov [esi], ebx	

	## Na slican nacin, cuvamo vrednost minimuma na za to predvidjenu
	## lokaciju.
	mov esi, [ebp + 20]
	mov [esi], edi
	
	## Epilog funkcije
	pop ebx
	pop edi
	pop esi
	leave
	ret
	
	
