.intel_syntax noprefix

.text
.global prost

##
## int prost(unsigned n)
##
## Funkcija ispituje da li je dati broj n prost. Argument
## funkcije:
##
## -- unsigned n -- [ebp + 8]
##
## Funkcija vraca 1 ako je broj prost, a 0 u suprotnom.
##
prost:
	## Prolog funkcije
	enter 0,0
	push edi
	
	## U registar edi ucitavamo broj n.
	mov edi, [ebp + 8]

	## Registar ecx ce nam biti tekuci broj za koji ispitujemo
	## da li deli broj n. Inicijalno je 2. U svakoj iteraciji
	## ga uvecavamo za 1, sve dok njegov kvadrat ne bude veci
	## od n.
	mov ecx, 2

sledeci_broj:
	## Mnozimo ecx sa samim sobom. Ako je kvadrat veci od n, tada
	## se zavrsava provera i broj je prost (jer nije deljiv ni
	## jednim brojem vecim od 1).
	mov eax, ecx
	mul ecx
	cmp eax, edi
	ja poslenji_broj

	## U suprotnom, delimo n sa ecx i proveravamo ostatak.
	mov eax, edi
	xor edx, edx
	div ecx

	## Ako je ostatak nula, tada je broj n deljiv sa ecx, pa nije
	## prost.
	cmp edx, 0
	je nije_prost

	## Uvecavamo brojac i prelazimo na sledecu iteraciju.
	inc ecx
	jmp sledeci_broj
poslenji_broj:
	
	## Ako je broj prost, tada vracamo 1. 
	mov eax, 1
	jmp kraj

nije_prost:
	## U suprotnom, vracamo 0.
	mov eax, 0

kraj:	
	## Epilog funkcije
	pop edi
	leave
	ret
	
