.intel_syntax noprefix

.text

.global ojler


############################################################################
##
## Funkcija odredjuje Ojlerovu funkciju datog neoznacenog celog broja.
## Argument funkcije je:
##
##  -- [ebp + 8] -- unsigned x
ojler:
	enter 0,0
	push edi
	push esi
	push ebx
	
	# Registar edi ce biti brojac uzajamno prostih brojeva sa x.
	xor edi, edi

	# Registar esi ce biti tekuci broj za koji ispitujemo da li je
	# uzajamno prost sa x.
	mov esi, 1

	# Registar ebx ce sadrzati vrednost x.
	mov ebx, [ebp + 8]
 
sledeci:
	# Dok je esi manje od x...
	cmp esi, ebx
	jae poslednji

	# Pozivamo nzd(esi, ebx). S obzirom da nam se relevantni podaci
	# nalaze iskljucivo u registrima koji pripadaju pozivajucoj
	# funkciji (esi, edi, ebx), ne moramo nista da cuvamo pre poziva,
	# jer po C-konvencijama, pozvana funkcija nece pokvariti ove registre.


	push esi
	push ebx
	call nzd
	add esp, 8

	
	# Nakon poziva, u eax se nalazi NZD(esi, ebx). Ako je ova vrednost
	# jedan, tada su uzajamno prosti, pa uvecavamo brojac uzajamno
	# prostih brojeva.  U suprotnom, preskacemo taj deo koda.
	cmp eax, 1
	jne preskoci

	inc edi
preskoci:
	# Uvecavamo tekuci broj i prelazimo na sledecu iteraciju.
	inc esi
	jmp sledeci
poslednji:	

	# Smestamo broj uzajamno prostih brojeva u eax, jer je to povratna
	# vrednost.
	mov eax, edi
	
	pop ebx
	pop esi
	pop edi
	leave
	ret
	
