.intel_syntax noprefix

.text

.global nzd

############################################################################
##
## Funkcija izracunava NZD dva neoznacena cela broja.
## Argumenti funkcije su:
##
## -- unsigned x - [ebp + 8]
## -- unsigned y - [ebp + 12]
##
############################################################################
nzd:
	enter 0,0

	# C-algoritam
	#   while(y)
	#   {
	#     r = x % y;
	#     x = y;
	#     y = r;
	#   }
	#   return x;

	# U eax smestamo x, a u ecx y.  
	mov eax, [ebp + 8]
	mov ecx, [ebp + 12]

petlja:
	# Ako je y == 0 izlazimo iz petlje
	cmp ecx, 0
	je kraj_petlje

	# Delimo x sa y (prethodno neoznaceno prosirujemo eax na edx)
	xor edx, edx
	div ecx

	# x = y, y = r
	mov eax, ecx
	mov ecx, edx

	# Prelazimo na sledecu iteraciju
	jmp petlja
kraj_petlje:	

	# Na kraju se u eax registru nalazi poslednja vrednost x, sto
	# je upravo trazeni NZD.
	leave
	ret
	
