.intel_syntax noprefix

.data

rdfmt:  .asciz "%d %d"
wrfmt:	.asciz "%d\n"
	
.text
.global main
	
main:
	## Prolog funkcije
	enter 8,0

	## NAPOMENA: Instrukcija enter n, 0 je ekvivalentna sledecem nizu
	## instrukcija:
	##
	## push ebp
	## mov ebp, esp
	## sub esp, n
	##
	## gde je n neka konstanta. Ovim se obelezava okvir steka tekuce
	## funkcije i rezervise n bajtova za lokalne podatke. U ovom slucaju
	## se na steku rezervise 8 bajtova (za dva podatka x i y).

	## NAPOMENA: Kada se na steku rezervise prostor za lokalne
	## promenljive, njima se pristupa relativno u odnosu na pocetak okvira
	## steka tekuce funkcije. Prvi podatak (x) se nalazi na adresi ebp - 4
	## dok se drugi podatak (y) nalazi na adresi ebp - 8.

	

	## Poziva se funkcija scanf("%d %d", &x, &y)
	## Ucitava se adresa y u eax, a zatim se ista stavlja na stek.
	lea eax, [ebp - 8]
	push eax
	## Ucitava se u eax adresa x, a zatim se ista stavlja na stek.
	lea eax, [ebp - 4]
	push eax
	## Ucitava se u eax aresa rdfmt a zatim se ista stavlja na stek.
	lea eax, rdfmt
	push eax
	## Poziva se funkcija scanf() (njoj odgovara istoimena labela)
	call scanf
	## Nakon povratka iz funkcije scanf() moramo da skinemo sa steka
	## parametre funkcije -- ovo se radi prostim dodavanjem 12 na
	## pokazivac steka (cime se vrh steka "pomera" na gore za 12 bajtova).
	add esp, 12

	## Poziva se funkcija saberi(x, y)
	## Postavljamo na stek 4-bajtni podatak y
	push dword ptr [ebp - 8]
	## Postavljamo na stek 4-bajtni podatak x
	push dword ptr [ebp - 4]
	## Pozivamo funkciju saberi()
	call saberi
	## Skidamo sa steka dva 4-bajtna podatka.
	add esp, 8

	## Poziva se funkcija printf("%d\n", saberi(x,y))
	## Postavljamo na stek vrednost povratne adrese funkcije saberi().
	push eax
	## Ucitavamo u eax adresu pocetka format stringa wrfmt, a zatim
	## istu postavljamo na stek.
	lea eax, wrfmt
	push eax
	## Pozivamo funkciju printf()
	call printf
	## Skidamo sa steka parametre funkcije printf().
	add esp, 8

	## Epilog funkcije
	xor eax, eax
	leave
	ret
