﻿USE master;
GO

IF DB_ID('DVDClub') IS NOT NULL
BEGIN
PRINT 'Deleting database DVDClub!';
DROP DATABASE DVDClub;
END
GO

PRINT 'Creating database DVDClub!';
CREATE DATABASE DVDClub;
GO

USE DVDClub;
GO


CREATE TABLE Genre 
(
 Name NVARCHAR(50) NOT NULL,
 CONSTRAINT PK_G PRIMARY KEY (Name)
);
GO


CREATE TABLE Movie
(
 ID INTEGER NOT NULL IDENTITY, 
 Name NVARCHAR(200) NOT NULL, 
 Year SMALLINT NOT NULL, 
 Rating FLOAT NOT NULL DEFAULT 1,
 CONSTRAINT PK_M PRIMARY KEY (ID)
);
GO

CREATE TABLE MovieGenre
(
 MovieID INTEGER NOT NULL,
 GenreName NVARCHAR(50) NOT NULL,
 CONSTRAINT PK_MG PRIMARY KEY (MovieID, GenreName),
 CONSTRAINT FK_MG_M FOREIGN KEY (MovieID) REFERENCES Movie
 ON DELETE CASCADE ON UPDATE NO ACTION,
 CONSTRAINT FK_MG_G FOREIGN KEY (GenreName) REFERENCES Genre
 ON DELETE NO ACTION ON UPDATE NO ACTION
);


CREATE TABLE Customer 
(
 ID INTEGER NOT NULL IDENTITY, 
 FirstName NVARCHAR(30) NOT NULL, 
 LastName NVARCHAR(30) NOT NULL, 
 YearOfBirth SMALLINT NOT NULL,
 CONSTRAINT PK_C PRIMARY KEY (ID)
);
GO

CREATE TABLE Employee
(
 ID INTEGER NOT NULL IDENTITY, 
 FirstName NVARCHAR(30) NOT NULL, 
 LastName NVARCHAR(30) NOT NULL,
 CONSTRAINT PK_E PRIMARY KEY (ID)
);
GO


CREATE TABLE Lease
(
 ID INTEGER NOT NULL IDENTITY,
 MovieID INTEGER NOT NULL, 
 CustomerID INTEGER NOT NULL, 
 LeaseDate DATE NOT NULL, 
 LeaseDays SMALLINT NOT NULL,
 EmployeeID INTEGER NOT NULL, 
 CONSTRAINT PK_L PRIMARY KEY (ID),
 CONSTRAINT FK_L_M FOREIGN KEY (MovieID) REFERENCES Movie
 ON DELETE CASCADE ON UPDATE NO ACTION,
 CONSTRAINT FK_L_C FOREIGN KEY (CustomerID) REFERENCES Customer
 ON DELETE CASCADE ON UPDATE NO ACTION,
 CONSTRAINT FK_L_E FOREIGN KEY (EmployeeID) REFERENCES Employee
 ON DELETE CASCADE ON UPDATE NO ACTION
);
GO

INSERT INTO Genre (Name)
VALUES ('Action');
INSERT INTO Genre (Name)
VALUES ('Comedy');
INSERT INTO Genre (Name)
VALUES ('Thriller');
INSERT INTO Genre (Name)
VALUES ('Horror');
INSERT INTO Genre (Name)
VALUES ('Drama');
INSERT INTO Genre (Name)
VALUES ('Adventure');
INSERT INTO Genre (Name)
VALUES ('Crime');
INSERT INTO Genre (Name)
VALUES ('Documentary');
INSERT INTO Genre (Name)
VALUES ('Fantasy');
INSERT INTO Genre (Name)
VALUES ('Historical');
INSERT INTO Genre (Name)
VALUES ('Epic');
INSERT INTO Genre (Name)
VALUES ('Romance');
INSERT INTO Genre (Name)
VALUES ('Saga');
INSERT INTO Genre (Name)
VALUES ('Romantic comedy');
INSERT INTO Genre (Name)
VALUES ('Science fiction');
INSERT INTO Genre (Name)
VALUES ('Superhero');
INSERT INTO Genre (Name)
VALUES ('Mystery');
INSERT INTO Genre (Name)
VALUES ('Political');
INSERT INTO Genre (Name)
VALUES ('Musical');
INSERT INTO Genre (Name)
VALUES ('Animated');
INSERT INTO Genre (Name)
VALUES ('Cartoon');
INSERT INTO Genre (Name)
VALUES ('Parody');
INSERT INTO Genre (Name)
VALUES ('Spy');
GO

INSERT INTO Movie (Name, Year, Rating)
VALUES ('American Beauty', 1999, 0.8);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Drama');


INSERT INTO Movie (Name, Year, Rating)
VALUES ('Galaxy Quest', 1999, 0.5);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Science fiction');
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Parody');


INSERT INTO Movie (Name, Year, Rating)
VALUES ('Catch Me If You Can', 2002, 1.1);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Comedy');
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Drama');


INSERT INTO Movie (Name, Year, Rating)
VALUES ('The Ring', 2002, 1.5);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Horror');


INSERT INTO Movie (Name, Year, Rating)
VALUES ('Shrek', 2001, 1.2);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Animated');


INSERT INTO Movie (Name, Year, Rating)
VALUES ('Madagascar', 2005, 1);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Animated');


INSERT INTO Movie (Name, Year, Rating)
VALUES ('Kung Fu Panda', 2009, 1);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Animated');


INSERT INTO Movie (Name, Year, Rating)
VALUES ('The Sound Of Music', 1965, 0.3);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Musical');


INSERT INTO Movie (Name, Year, Rating)
VALUES ('Fantastic Voyage', 1966, 0.3);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Science fiction');


INSERT INTO Movie (Name, Year, Rating)
VALUES ('Star Wars', 1977, 1.2);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Science fiction');


INSERT INTO Movie (Name, Year, Rating)
VALUES ('X-Man', 2000, 1.3);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Superhero');

INSERT INTO Movie (Name, Year, Rating)
VALUES ('Die Hard', 1988, 1.5);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Action');

INSERT INTO Movie (Name, Year, Rating)
VALUES ('Die Hard 2', 1990, 1.5);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Action');

INSERT INTO Movie (Name, Year, Rating)
VALUES ('Alien', 1979, 1.6);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Science fiction');
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Horror');
       

INSERT INTO Movie (Name, Year, Rating)
VALUES ('Aliens', 1986, 1.7);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Science fiction');
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Horror');
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Action');
   
INSERT INTO Movie (Name, Year, Rating)
VALUES ('Alien 3', 1992, 1.2);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Science fiction');
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Horror');
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Action');


INSERT INTO Movie (Name, Year, Rating)
VALUES ('Planet Of The Apes', 1968, 0.8);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Science fiction');


INSERT INTO Movie (Name, Year, Rating)
VALUES ('Planet Of The Apes', 2001, 0.9);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Science fiction');


INSERT INTO Movie (Name, Year, Rating)
VALUES ('Home Alone', 1990, 1.4);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Comedy');


INSERT INTO Movie (Name, Year, Rating)
VALUES ('Home Alone 2: Lost In New York', 1992, 1.4);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Comedy');

        
INSERT INTO Movie (Name, Year, Rating)
VALUES ('Home Alone 3', 1997, 1.4);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Comedy');

INSERT INTO Movie (Name, Year, Rating)
VALUES ('Home Alone 4: Taking Back The House', 2002, 1.4);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Comedy');


INSERT INTO Movie (Name, Year, Rating)
VALUES ('Night At The Museum', 2006, 1);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Fantasy');
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Adventure');
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Comedy');

INSERT INTO Movie (Name, Year, Rating)
VALUES ('Predator', 1987, 1.5);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Science fiction');
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Action');
       
INSERT INTO Movie (Name, Year, Rating)
VALUES('Speed', 1994, 1.4);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Action');
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Thriller');


INSERT INTO Movie (Name, Year, Rating)
VALUES('Independence Day', 1996, 1.4);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Action');
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Science fiction');
   
INSERT INTO Movie (Name, Year, Rating)
VALUES('Avatar', 2009, 1.4);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Science fiction');
 
INSERT INTO Movie (Name, Year, Rating)
VALUES ('Spartacus', 1960, 0.5);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Historical');
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Epic');

INSERT INTO Movie (Name, Year, Rating)
VALUES ('Jaws', 1975, 1.2);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Horror');
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Thriller');

INSERT INTO Movie (Name, Year, Rating)
VALUES ('The Blues Brothers', 1980, 1);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Musical');
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Comedy');

INSERT INTO Movie (Name, Year, Rating)
VALUES ('Back To The Future', 1985, 1);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Science fiction');
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Adventure');

INSERT INTO Movie (Name, Year, Rating)
VALUES ('Jurrasic Park', 1993, 1.4);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Science fiction');
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Adventure');

INSERT INTO Movie (Name, Year, Rating)
VALUES ('The Lost World: Jurrasic Park', 1997, 1.4);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Science fiction');
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Adventure');

INSERT INTO Movie (Name, Year, Rating)
VALUES ('Jurrasic Park III', 2001, 1.4);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Science fiction');
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Adventure');

INSERT INTO Movie (Name, Year, Rating)
VALUES ('The Flintstones', 1994, 1);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Comedy');

INSERT INTO Movie (Name, Year, Rating)
VALUES ('The Bourne Identity', 2002, 1.2);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Spy');

INSERT INTO Movie (Name, Year, Rating)
VALUES ('The Terminator', 1984, 1.8);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Action');
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Science fiction');


INSERT INTO Movie (Name, Year, Rating)
VALUES ('Terminator 2: Judgment Day', 1991, 2);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Action');
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Science fiction');


INSERT INTO Movie (Name, Year, Rating)
VALUES ('Terminator 3: Rise Of The Machines', 2003, 1.2);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Action');
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Science fiction');

INSERT INTO Movie (Name, Year, Rating)
VALUES ('Terminator Salvation', 2009, 1.2);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Action');
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Science fiction');


INSERT INTO Movie (Name, Year, Rating)
VALUES ('Indiana Jones And The Raiders Of The Lost Ark', 1981, 1.5);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Action');
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Adventure');

  
INSERT INTO Movie (Name, Year, Rating)
VALUES ('Indiana Jones And The Temple Of Doom', 1984, 1.5);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Action');
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Adventure');

        
INSERT INTO Movie (Name, Year, Rating)
VALUES ('Indiana Jones And The Last Crusade', 1989, 1.5);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Action');
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Adventure');

        
INSERT INTO Movie (Name, Year, Rating)
VALUES ('Indiana Jones And The Kingdom Of The Crystal Scull', 2008, 1.5);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Action');
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Adventure');

               
INSERT INTO Movie (Name, Year, Rating)
VALUES ('Pirates Of The Caribbean: On Stranger Tides', 2011, 1.5);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Fantasy');
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Adventure');


INSERT INTO Movie (Name, Year, Rating)
VALUES ('Pirates Of The Caribbean: The Curse of the Black Pearl', 2003, 1.5);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Fantasy');
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Adventure');
 
INSERT INTO Movie (Name, Year, Rating)
VALUES ('Pirates Of The Caribbean: Dead Man''s Chest', 2006, 1.5);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Fantasy');
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Adventure');
  

INSERT INTO Movie (Name, Year, Rating)
VALUES ('Pirates Of The Caribbean: At World''s End', 2007, 1.5);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Fantasy');
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Adventure');
 

INSERT INTO Movie (Name, Year, Rating)
VALUES ('Forrest Gump', 1994, 1.5);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Comedy');
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Drama');
      

INSERT INTO Movie (Name, Year, Rating)
VALUES ('Men In Black', 1997, 1.3);
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Comedy');
INSERT INTO MovieGenre 
VALUES ((SELECT MAX(ID) FROM Movie), 'Science fiction');
                  
GO


INSERT INTO Employee (FirstName, LastName)
VALUES('Petar', N'Jovanović');
INSERT INTO Employee (FirstName, LastName)
VALUES(N'Žarko', N'Novaković');
INSERT INTO Employee (FirstName, LastName)
VALUES('Ivana', N'Golubović');
INSERT INTO Employee (FirstName, LastName)
VALUES('Sandra', N'Stojiljković');
INSERT INTO Employee (FirstName, LastName)
VALUES('Goran', N'Stojanov');
INSERT INTO Employee (FirstName, LastName)
VALUES('Vesna', N'Stefanović');

GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES('Milan', N'Banković', 1982);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES('Ivan', N'Perić', 1987);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES('Marko', N'Veljković', 1984);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES('Dragan', N'Milošević', 1996);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES('Sanja', N'Marković', 1988);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES('Jovana', N'Obradović', 1974);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES(N'Siniša', N'Đorđević', 1989);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES('Dragutin', N'Milivojević', 1946);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES('Milena', N'Bakočević', 1986);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES('Ivana', N'Pejović', 1982);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES('Danijela', N'Nikolić', 1995);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES('Dijana', N'Milovanović', 2002);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES('Stefan', N'Milić', 1990);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES('Jovan', N'Urošević', 1980);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES(N'Miloš', N'Mirković', 1983);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES('Nemanja', N'Stanojević', 1982);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES(N'Srđan', N'Radovanović', 1986);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES('Milica', N'Marinković', 1985);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES('Aleksandra', N'Trifunović', 1991);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES('Marina', N'Savković', 2001);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES('Jelena', N'Rakočević', 1985);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES('Sanja', N'Aleksić', 1981);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES('Dejan', N'Aleksić', 1983);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES('Marija', N'Lazić', 1982);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES('Ljiljana', N'Janković', 1976);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES('Aleksandar', N'Stojković', 1984);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES('Marko', N'Blagojević', 1984);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES(N'Željko', N'Obradović', 1984);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES('Tanja', N'Vasojević', 1981);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES('Katarina', N'Mirić', 1989);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES('Dragana', N'Zlatanović', 1987);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES('Violeta', N'Ranković', 1994);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES('Janko', N'Perović', 1992);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES('Predrag', N'Živanović', 1987);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES('Nenad', N'Živanović', 1987);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES('Bojana', N'Lazić', 1994);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES('Milica', N'Mitrović', 1984);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES('Zorana', N'Dragutinović', 1979);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES('Sofija', N'Janjić', 1990);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES('Jovana', N'Simeunović', 1997);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES('Janko', N'Perović', 1986);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES('Marija', N'Lazić', 1988);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES('Sanja', N'Aleksić', 1985);
GO


INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES('Jelena', N'Rakočević', 1985);
GO

INSERT INTO Customer (FirstName, LastName, YearOfBirth)
VALUES('Stefan', N'Milić', 2001);
GO

INSERT INTO Lease 
VALUES(32, 35, '2011/08/23', 2, 1);
	
INSERT INTO Lease 
VALUES(12, 15, '2011/10/13', 2, 1);

INSERT INTO Lease 
VALUES(5, 28, '2011/10/22', 3, 3);

INSERT INTO Lease 
VALUES(3, 28, '2011/10/20', 1, 4);

INSERT INTO Lease 
VALUES(45, 43, '2011/09/15', 3, 3);

INSERT INTO Lease 
VALUES(3, 37, '2011/09/24', 1,  5);

INSERT INTO Lease 
VALUES(26, 30, '2011/10/12', 2, 6);

INSERT INTO Lease 
VALUES(50, 45, '2011/10/18', 3,  6);

INSERT INTO Lease 
VALUES(48, 27, '2011/10/10', 3,  3);

INSERT INTO Lease 
VALUES(16, 16, '2011/10/10', 2, 2);

INSERT INTO Lease 
VALUES(20, 40, '2011/10/21', 1,  1);

INSERT INTO Lease 
VALUES(11, 13, '2011/10/24', 1,  4);

INSERT INTO Lease 
VALUES(23, 37, '2011/10/14', 3,  5);

INSERT INTO Lease 
VALUES(24, 36, '2011/10/23', 1,  4);

INSERT INTO Lease 
VALUES(25, 35, '2011/10/20', 1,  2);

INSERT INTO Lease 
VALUES(26, 34, '2011/10/18', 2,  1);

INSERT INTO Lease 
VALUES(27, 33, '2011/08/08', 3,  3);

INSERT INTO Lease 
VALUES(28, 32, '2011/08/10', 3,  4);

INSERT INTO Lease 
VALUES(29, 31, '2011/09/10', 3,  4);

INSERT INTO Lease 
VALUES(30, 30, '2011/10/15', 2,  2);

INSERT INTO Lease 
VALUES(31, 29, '2011/10/15', 1,  5);

INSERT INTO Lease 
VALUES(32, 28, '2011/10/16', 2,  3);

INSERT INTO Lease 
VALUES(33, 27, '2011/10/20', 2,  6);

INSERT INTO Lease 
VALUES(33, 27, '2011/10/23', 1,  1);

INSERT INTO Lease 
VALUES(34, 26, '2011/10/15', 2,  6);

INSERT INTO Lease 
VALUES(35, 25, '2011/10/11', 1,  2);

INSERT INTO Lease 
VALUES(36, 24, '2011/10/05', 2, 3);

INSERT INTO Lease 
VALUES(37, 23, '2011/08/18', 3,  4);

INSERT INTO Lease 
VALUES(38, 22, '2011/09/12', 2,  5);

INSERT INTO Lease 
VALUES(39, 21, '2011/09/13', 1,  2);

INSERT INTO Lease 
VALUES(40, 20, '2011/09/20', 2,  6);

INSERT INTO Lease 
VALUES(41, 26, '2011/10/21', 1, 1);

INSERT INTO Lease 
VALUES(42, 25, '2011/10/15', 2, 5);

INSERT INTO Lease 
VALUES(42, 25, '2011/08/20', 2,  3);

INSERT INTO Lease 
VALUES(43, 24, '2011/08/25', 1,  6);

INSERT INTO Lease 
VALUES(44, 23, '2011/09/02', 4,  2);

INSERT INTO Lease 
VALUES(44, 22, '2011/10/20', 2,  1);

INSERT INTO Lease 
VALUES(45, 21, '2011/08/07', 2,  3);

INSERT INTO Lease 
VALUES(46, 20, '2011/09/05', 1,  5);

INSERT INTO Lease 
VALUES(47, 19, '2011/10/02', 3,  2);

INSERT INTO Lease 
VALUES(48, 18, '2011/09/18', 1,  4);

INSERT INTO Lease 
VALUES(49, 17, '2011/08/28', 1,  1);

INSERT INTO Lease 
VALUES(50, 16, '2011/09/15', 3,  6);

INSERT INTO Lease 
VALUES(1, 15, '2011/10/11', 4,  1);

INSERT INTO Lease 
VALUES(2, 14, '2011/08/20', 1,  5);

INSERT INTO Lease 
VALUES(3, 13, '2011/09/07', 2,  3);

INSERT INTO Lease 
VALUES(4, 12, '2011/08/03', 1,  6);

INSERT INTO Lease 
VALUES(5, 11, '2011/10/19', 2,  2);

INSERT INTO Lease 
VALUES(6, 10, '2011/10/13', 2,  4);

INSERT INTO Lease 
VALUES(7, 9, '2011/10/12', 3,  1);

INSERT INTO Lease 
VALUES(8, 10, '2011/10/09', 2, 3);

INSERT INTO Lease 
VALUES(9, 9, '2011/10/06', 1,  5);

INSERT INTO Lease 
VALUES(10, 8, '2011/10/18', 4, 6);

INSERT INTO Lease 
VALUES(11, 7, '2011/10/05', 1, 2);

INSERT INTO Lease 
VALUES(12, 6, '2011/10/22', 2, 1);

INSERT INTO Lease 
VALUES(13, 5, '2011/10/10', 2, 2);

INSERT INTO Lease 
VALUES(14, 4, '2011/09/09', 1, 5);

INSERT INTO Lease 
VALUES(15, 3, '2011/10/19', 2, 3);

INSERT INTO Lease 
VALUES(16, 3, '2011/10/19', 2, 3);

INSERT INTO Lease 
VALUES(17, 2, '2011/08/23', 2, 4);

INSERT INTO Lease 
VALUES(18, 1, '2011/10/01', 5, 5);

INSERT INTO Lease 
VALUES(18, 1, '2011/10/18', 2, 1);

INSERT INTO Lease 
VALUES(22, 1, '2011/10/18', 2, 1);

INSERT INTO Lease 
VALUES(21, 45, '2011/10/15', 5, 2);

INSERT INTO Lease 
VALUES(20, 44, '2011/10/11', 3,  5);

INSERT INTO Lease 
VALUES(19, 43, '2011/09/28', 2,  2);

INSERT INTO Lease 
VALUES(18, 42, '2011/10/14', 4,  1);


INSERT INTO Lease 
VALUES(12, 25, '2011/08/23', 1,  3);
	
INSERT INTO Lease 
VALUES(2, 31, '2011/10/13', 3,  4);

INSERT INTO Lease 
VALUES(45, 18, '2011/10/22', 2, 1);

INSERT INTO Lease 
VALUES(23, 38, '2011/10/20', 1, 4);

INSERT INTO Lease 
VALUES(35, 33, '2011/09/15', 3, 3);

INSERT INTO Lease 
VALUES(31, 7, '2011/09/24', 1,  5);

INSERT INTO Lease 
VALUES(22, 22, '2011/10/12', 2, 6);

INSERT INTO Lease 
VALUES(40, 17, '2011/10/18', 3, 4);

INSERT INTO Lease 
VALUES(41, 12, '2011/10/10', 3, 3);

INSERT INTO Lease 
VALUES(36, 26, '2011/10/10', 2, 2);

INSERT INTO Lease 
VALUES(10, 30, '2011/10/21', 1, 1);

INSERT INTO Lease 
VALUES(12, 14, '2011/10/24', 1, 4);

INSERT INTO Lease 
VALUES(28, 32, '2011/10/14', 3, 5);

INSERT INTO Lease 
VALUES(31, 26, '2011/10/23', 1, 4);

INSERT INTO Lease 
VALUES(40, 44, '2011/10/20', 1, 2);

INSERT INTO Lease 
VALUES(29, 33, '2011/10/18', 2,  1);

INSERT INTO Lease 
VALUES(17, 3, '2011/08/08', 3,  2);

INSERT INTO Lease 
VALUES(18, 2, '2011/08/10', 3,  4);

INSERT INTO Lease 
VALUES(19, 1, '2011/09/10', 3,  4);

INSERT INTO Lease 
VALUES(20, 20, '2011/10/15', 2, 2);

INSERT INTO Lease 
VALUES(21, 19, '2011/10/15', 1, 5);

INSERT INTO Lease 
VALUES(22, 18, '2011/10/16', 2, 3);

INSERT INTO Lease 
VALUES(23, 17, '2011/10/20', 2, 6);

INSERT INTO Lease 
VALUES(23, 17, '2011/10/23', 1, 1);

INSERT INTO Lease 
VALUES(24, 16, '2011/10/15', 2, 5);

INSERT INTO Lease 
VALUES(25, 15, '2011/10/11', 2, 2);

INSERT INTO Lease 
VALUES(26, 14, '2011/10/06', 2, 1);

INSERT INTO Lease 
VALUES(27, 13, '2011/08/18', 3, 4);

INSERT INTO Lease 
VALUES(28, 12, '2011/09/12', 2, 5);

INSERT INTO Lease 
VALUES(29, 11, '2011/09/13', 1, 2);

INSERT INTO Lease 
VALUES(30, 10, '2011/09/20', 3, 3);

INSERT INTO Lease 
VALUES(31, 9, '2011/10/21', 1,  1);

INSERT INTO Lease 
VALUES(32, 8, '2011/10/15', 2, 5);

INSERT INTO Lease 
VALUES(35, 7, '2011/08/20', 2, 3);

INSERT INTO Lease 
VALUES(33, 6, '2011/08/25', 1,  6);

INSERT INTO Lease 
VALUES(3, 5, '2011/09/02', 4,  2);

INSERT INTO Lease 
VALUES(3, 4, '2011/10/20', 2, 1);

INSERT INTO Lease 
VALUES(2, 3, '2011/08/07', 2,  3);

INSERT INTO Lease 
VALUES(16, 30, '2011/09/05', 1, 5);

INSERT INTO Lease 
VALUES(17, 39, '2011/10/02', 3,  2);

INSERT INTO Lease 
VALUES(18, 18, '2011/09/18', 1,  4);

INSERT INTO Lease 
VALUES(19, 15, '2011/08/28', 1, 1);

INSERT INTO Lease 
VALUES(40, 16, '2011/09/15', 3,  6);

INSERT INTO Lease 
VALUES(10, 15, '2011/10/11', 4, 1);

INSERT INTO Lease 
VALUES(20, 14, '2011/08/20', 1,  5);

INSERT INTO Lease 
VALUES(30, 13, '2011/09/07', 2,  3);

INSERT INTO Lease 
VALUES(40, 12, '2011/08/03', 1,  6);

INSERT INTO Lease 
VALUES(50, 11, '2011/10/19', 2,  2);

INSERT INTO Lease 
VALUES(6, 20, '2011/10/13', 2,  4);

INSERT INTO Lease 
VALUES(7, 19, '2011/10/12', 3,  1);

INSERT INTO Lease 
VALUES(8, 18, '2011/10/09', 2,  3);

INSERT INTO Lease 
VALUES(9, 19, '2011/10/06', 1,  5);

INSERT INTO Lease 
VALUES(10, 17, '2011/10/18', 4, 6);

INSERT INTO Lease 
VALUES(11, 17, '2011/10/05', 1, 2);

INSERT INTO Lease 
VALUES(12, 16, '2011/10/22', 2,  1);

INSERT INTO Lease 
VALUES(13, 15, '2011/10/10', 2,  2);

INSERT INTO Lease 
VALUES(14, 14, '2011/09/09', 1,  5);

INSERT INTO Lease 
VALUES(15, 13, '2011/10/19', 2,  3);

INSERT INTO Lease 
VALUES(16, 12, '2011/10/19', 2,  3);

INSERT INTO Lease 
VALUES(17, 12, '2011/08/23', 2,  4);

INSERT INTO Lease 
VALUES(18, 11, '2011/10/01', 5,  5);

INSERT INTO Lease 
VALUES(18, 10, '2011/10/18', 2,  1);

INSERT INTO Lease 
VALUES(25, 11, '2011/10/18', 2,  1);

INSERT INTO Lease 
VALUES(26, 41, '2011/10/15', 5,  2);

INSERT INTO Lease 
VALUES(27, 40, '2011/10/12', 3,  3);

INSERT INTO Lease 
VALUES(29, 33, '2011/09/28', 2,  4);

INSERT INTO Lease 
VALUES(1, 42, '2011/10/14', 4,  1);








INSERT INTO Lease 
VALUES(13, 24, '2011/08/23', 1,  3);
	
INSERT INTO Lease 
VALUES(4, 30, '2011/10/13', 3,  4);

INSERT INTO Lease 
VALUES(42, 20, '2011/10/22', 2,  1);

INSERT INTO Lease 
VALUES(25, 35, '2011/10/20', 2,  4);

INSERT INTO Lease 
VALUES(37, 30, '2011/09/15', 3,  3);

INSERT INTO Lease 
VALUES(33, 3, '2011/09/24', 1,  5);

INSERT INTO Lease 
VALUES(25, 20, '2011/10/12', 2, 6);

INSERT INTO Lease 
VALUES(42, 15, '2011/10/18', 3,  4);

INSERT INTO Lease 
VALUES(18, 17, '2011/10/10', 3,  3);

INSERT INTO Lease 
VALUES(26, 36, '2011/10/10', 2, 2);

INSERT INTO Lease 
VALUES(30, 10, '2011/10/21', 1,  1);

INSERT INTO Lease 
VALUES(14, 14, '2011/10/24', 1,  4);

INSERT INTO Lease 
VALUES(32, 28, '2011/10/14', 3,  5);

INSERT INTO Lease 
VALUES(26, 31, '2011/10/23', 1,  4);

INSERT INTO Lease 
VALUES(44, 44, '2011/10/20', 1,  2);

INSERT INTO Lease 
VALUES(29, 39, '2011/10/18', 2,  1);

INSERT INTO Lease 
VALUES(17, 17, '2011/08/08', 3,  4);

INSERT INTO Lease 
VALUES(18, 18, '2011/08/10', 3,  4);

INSERT INTO Lease 
VALUES(19, 19, '2011/09/10', 3,  4);

INSERT INTO Lease 
VALUES(20, 20, '2011/10/15', 2,  4);

INSERT INTO Lease 
VALUES(21, 21, '2011/10/15', 1,  5);

INSERT INTO Lease 
VALUES(22, 22, '2011/10/16', 2,  3);

INSERT INTO Lease 
VALUES(23, 23, '2011/10/20', 2,  4);

INSERT INTO Lease 
VALUES(23, 24, '2011/10/23', 1,  1);

INSERT INTO Lease 
VALUES(24, 32, '2011/10/15', 2,  5);

INSERT INTO Lease 
VALUES(25, 33, '2011/10/11', 2,  4);

INSERT INTO Lease 
VALUES(26, 34, '2011/10/06', 2,  1);

INSERT INTO Lease 
VALUES(27, 35, '2011/08/18', 3,  4);

INSERT INTO Lease 
VALUES(28, 36, '2011/09/12', 2,  5);

INSERT INTO Lease 
VALUES(29, 37, '2011/09/13', 1,  4);

INSERT INTO Lease 
VALUES(31, 39, '2011/10/21', 1,  1);

INSERT INTO Lease 
VALUES(32, 40, '2011/10/15', 2, 5);

INSERT INTO Lease 
VALUES(31, 41, '2011/08/20', 2,  4);

INSERT INTO Lease 
VALUES(32, 42, '2011/08/25', 1,  6);

INSERT INTO Lease 
VALUES(33, 43, '2011/09/02', 4,  4);

INSERT INTO Lease 
VALUES(34, 44, '2011/10/20', 2,  1);

INSERT INTO Lease 
VALUES(25, 45, '2011/08/07', 2,  3);

INSERT INTO Lease 
VALUES(26, 30, '2011/09/05', 1,  5);

INSERT INTO Lease 
VALUES(27, 29, '2011/10/02', 3,  2);

INSERT INTO Lease 
VALUES(28, 28, '2011/09/18', 1,  3);

INSERT INTO Lease 
VALUES(29, 25, '2011/08/28', 1,  2);

INSERT INTO Lease 
VALUES(20, 26, '2011/09/15', 3,  1);

INSERT INTO Lease 
VALUES(20, 25, '2011/10/11', 4,  6);

INSERT INTO Lease 
VALUES(20, 24, '2011/08/20', 1,  5);

INSERT INTO Lease 
VALUES(30, 23, '2011/09/07', 2,  3);

INSERT INTO Lease 
VALUES(30, 22, '2011/08/03', 1,  5);

INSERT INTO Lease 
VALUES(30, 21, '2011/10/19', 2,  2);

INSERT INTO Lease 
VALUES(26, 10, '2011/10/13', 2,  1);

INSERT INTO Lease 
VALUES(27, 9, '2011/10/12', 3, 2);

INSERT INTO Lease 
VALUES(28, 8, '2011/10/09', 2, 3);

INSERT INTO Lease 
VALUES(29, 9, '2011/10/06', 1, 5);

INSERT INTO Lease 
VALUES(30, 7, '2011/10/18', 4, 3);

INSERT INTO Lease 
VALUES(31, 7, '2011/10/05', 1, 2);

INSERT INTO Lease 
VALUES(32, 6, '2011/10/22', 2, 1);

INSERT INTO Lease 
VALUES(33, 5, '2011/10/10', 2,  2);

INSERT INTO Lease 
VALUES(34, 4, '2011/09/09', 1,  5);

INSERT INTO Lease 
VALUES(35, 3, '2011/10/19', 2,  6);

INSERT INTO Lease 
VALUES(36, 2, '2011/10/19', 2,  3);

INSERT INTO Lease 
VALUES(37, 1, '2011/08/23', 2,  4);

INSERT INTO Lease 
VALUES(38, 1, '2011/10/01', 5,  5);

INSERT INTO Lease 
VALUES(38, 10, '2011/10/18', 2, 4);

INSERT INTO Lease 
VALUES(35, 11, '2011/10/18', 2, 1);

INSERT INTO Lease 
VALUES(36, 21, '2011/10/15', 5,  1);

INSERT INTO Lease 
VALUES(37, 20, '2011/10/12', 3,  2);

INSERT INTO Lease 
VALUES(39, 23, '2011/09/28', 2,  3);

INSERT INTO Lease 
VALUES(31, 22, '2011/10/14', 4,  1);


	
	
