#include <stdio.h>
#include <stdlib.h>


/* NAPOMENA: U ovom primeru su sve funkcije iz prethodnih 
   primera definisane rekurzivno, ukoliko je to bilo moguce. 
   Primetno je  da  su  ove  rekurzivne  varijante  mnogo 
   jednostavnije. Razlog je to sto su liste po svojoj prirodi 
   rekurzivne strukture. Naime, liste se mogu rekurzivno 
   definisati na sledeci nacin:
   -  objekat oznacen sa [] je lista (prazna lista)
   -  ako je L lista, i G neki element, tada je uredjeni par
      (G,L) takodje lista. Element G nazivamo glavom liste,
      a listu L repom liste. 
   Na primer, uredjeni par (2, []) je lista, i po dogovoru
   cemo je zapisivati kao [2]. Takodje par (3,[2]) je lista
   koju mozemo zapisati kao [3 2], itd.
 
   U opstem slucaju, ako je L=[a1 a2 a3 ... an] lista, i ako je
   b neki element, tada je uredjeni par (b,L) takodje lista, koju
   mozemo zapisati kao [b a1 a2 ... an]. Glava liste je b, a rep
   liste je lista L. Sada se obrada liste moze razdvojiti na dva
   dela:
   - Izvrsiti operaciju nad glavom liste
   - Izvrsiti rekurzivni postupak nad repom liste (koji je takodje 
     lista).
*/

/* Struktura koja predstavlja cvor liste */
typedef struct cvor {
int vrednost;          /* podatak koji cvor sadrzi */
struct cvor *sledeci;  /* pokazivac na sledeci cvor */
} Cvor;


/* Pomocna funkcija koja kreira cvor. Funkcija vrednost
   novog cvora inicijalizuje na broj, dok pokazivac na
   sledeci cvor u novom cvoru postavlja na NULL. Funkcija 
   ispisuje poruku o gresci i prekida program u slucaju
   da malloc() funkcija ne uspe da alocira prostor. 
   Funkcija vraca pokazivac na novokreirani cvor */
Cvor * napravi_cvor(int broj)
{
     Cvor *novi = NULL;
     if((novi = (Cvor *) malloc(sizeof(Cvor))) == NULL)
       {
           fprintf(stderr,"malloc() greska!\n");
           exit(1);
       }

     novi->vrednost = broj;
     novi->sledeci = NULL;
     return novi;
}

/* Funkcija dodaje novi cvor na pocetak liste. Funkcija
   kreira novi cvor koriscenjem funkcije napravi_cvor().
   Funkcija vraca pokazivac na novu glavu liste */
Cvor * dodaj_na_pocetak_liste(Cvor *glava, int broj)
{
    Cvor * novi = napravi_cvor(broj);
    novi->sledeci = glava;
    return novi; 
}

/* Funkcija dodaje novi cvor na kraj liste. Funkcija
   kreira novi cvor koriscenjem funkcije napravi_cvor().
   Funkcija vraca pokazivac na glavu liste (koji moze
   biti promenjen u slucaju da je lista inicijalno bila 
   prazna). Funkcija koristi rekurziju. */
Cvor * dodaj_na_kraj_liste(Cvor *glava, int broj)
{
  /* Izlaz iz rekurzije: slucaj prazne liste. 
     U tom slucaju je glava nove liste upravo novi cvor. */
  if(glava == NULL) return napravi_cvor(broj);

  /* U slucaju da je lista neprazna, tada ona ima glavu i rep,
     pri cemu je rep opet lista. Tada je dodavanje na kraj
     liste ekvivalentno dodavanju na kraj repa liste, sto 
     radimo rekurzivnim pozivom. Povratna vrednost rekurzivnog
     poziva je adresa glave modifikovanog repa liste koja se 
     treba sacuvati u pokazivacu na sledeci u glavi */
  glava->sledeci = dodaj_na_kraj_liste(glava->sledeci, broj);

   /* Vracamo novu - staru glavu liste */
   return glava;
}

/* Funkcija dodaje novi element u sortiranu listu tako da i nova
   lista ostane sortirana. Funkcija kreira novi cvor koriscenjem
   funkcije napravi_cvor(). Funkcija vraca pokazivac na glavu liste
   (koji moze biti promenjen u slucaju da je novi element dodat na
    pocetak liste). Funkcija koristi rekurziju. */
Cvor * dodaj_sortirano(Cvor *glava, int broj)
{
   /* u slucaju da je lista prazna, ili da je vrednost
      glave veca ili jednaka od vrednosti broja koji
      umecemo, tada se novi cvor umece na pocetak liste. */
   if(glava == NULL || glava->vrednost >= broj) 
     {
        Cvor * novi = napravi_cvor(broj);
        novi->sledeci = glava;
        return novi;
     }

   /* U slucaju da je lista neprazna, i da je vrednost 
      glave manja od vrednosti broja koji umecemo u listu,
      tada je sigurno da se novi element umece DESNO od glave,
      tj. u rep liste. Dakle, mozemo rekurzivno pozvati istu
      funkciju za rep liste. S obzirom da po induktivnoj 
      pretpostavci rep nakon toga ostaje sortiran, a svi
      elementi u repu ukljucujuci i element koji je dodat
      su jednaki ili veci od glave, tada ce i cela lista
      biti sortirana. Povratna vrednost rekurzivnog poziva
      predstavlja adresu glave modifikovanog repa liste,
      pa se ta adresa mora sacuvati u pokazivacu na sledeci 
      u glavi liste. */
   glava->sledeci = dodaj_sortirano(glava->sledeci, broj);

   /* vracamo staru - novu glavu */
   return glava;
}

/* Funkcija trazi u listi element cija je vrednost jednaka 
   datom broju. Funkcija vraca pokazivac na cvor liste u 
   kome je sadrzan trazeni broj ili NULL u slucaju da takav 
   element ne postoji u listi. Funkcija koristi rekurziju. */
Cvor * pretrazi_listu(Cvor *glava, int broj)
{
     /* Izlaz iz rekurzije: prazna lista */
     if(glava == NULL) return NULL;

     /* ako je glava jednaka datom broju, vracamo adresu glave */
     if(glava->vrednost == broj) 
        return glava;
     /* u suprotnom pretrazujemo rep rekurzivnim pozivom i vracamo
        ono sto taj rekurzivni poziv vrati */
     else
        return pretrazi_listu(glava->sledeci, broj);

}

/* Funkcija brise iz liste sve cvorove koji sadrze dati broj.
   Funkcija vraca pokazivac na glavu liste (koji moze biti 
   promenjen u slucaju da se obrise stara glava). Funkcija
   koristi rekurziju. */
Cvor * obrisi_element(Cvor *glava, int broj)
{
  
   /* Izlaz iz rekurzije: prazna lista ostaje prazna nakon
      brisanja elemenata koji su jednaki sa brojem */
   if(glava == NULL) return NULL;

   /* Rekurzivno iz repa uklanjamo sve pojave datog broja.
      Rekurzivni poziv vraca adresu glave tako modifikovanog 
      repa, koja se cuva u pokazivacu na sledeci u okviru glave */
   glava->sledeci = obrisi_element(glava->sledeci, broj);


   /* Nakon ovoga znamo da u repu nema pojava datog broja. Jedino
      ostaje da proverimo jos i glavu, i da je po potrebi obrisemo */
   if(glava->vrednost == broj)
    {
       Cvor * pomocni = glava;
       glava = glava->sledeci;
       free(pomocni);
    }

     /* vracamo novu glavu */
     return glava;
}

/* Pomocna rekurzivna funkcija koja prikazuje
   listu. Definisana je kao static, cime se 
   sprecava njeno koriscenje od strane funkcija
   koje nisu definisane u ovom fajlu */
static void prikazi_listu_r(Cvor *glava)
{

/* Izlaz iz rekurzije */
if(glava == NULL) return;

/* Prikaz glave */
printf("%d ", glava->vrednost);

/* Prikaz repa (rekurzivnim pozivom) */
prikazi_listu_r(glava->sledeci);


}

/* Funkcija prikazuje elemente liste pocev od glave 
   ka kraju liste. Koristi rekurzivnu funkciju 
   prikazi_listu_r(). Ova funkcija prosto dodaje 
   uglaste zagrade i novi red na kraju ispisa. */
void prikazi_listu(Cvor *glava)
{
   putchar('[');
   
   prikazi_listu_r(glava); 
  
   putchar(']');

   putchar('\n');
}

/* Funkcija oslobadja dinamicku memoriju zauzetu 
   od strane liste. Funkcija koristi rekurziju. */
Cvor * oslobodi_listu(Cvor *glava)
{
  /* Izlaz iz rekurzije */
  if(glava == NULL) return NULL;

  /* Oslobadjamo rep liste */
  oslobodi_listu(glava->sledeci);

  /* Oslobadjamo glavu liste */
  free(glava);

  return NULL;
}


/* test program */
int main()
{

Cvor *glava = NULL;
Cvor *pomocni = NULL;
int broj;


/* Testiranje dodavanja na pocetak */
printf("-------------------------------------------------------\n");
printf("---------- Testiranje dodavanja na pocetak ------------\n");
do {
printf("-------------------------------------------------------\n");
printf("Prikaz trenutnog sadrzaja liste:\n");
prikazi_listu(glava);
printf("-------------------------------------------------------\n");
printf("Dodati element na pocetak liste (ctrl-D za kraj unosa):\n");
} while(scanf("%d", &broj) > 0 &&  
                    (glava = dodaj_na_pocetak_liste(glava, broj)) );

printf("-------------------------------------------------------\n");
putchar('\n');

/* Testiranje pretrage elementa */
printf("-------------------------------------------------------\n");
printf("---------------- Testiranje pretrage ------------------\n");
printf("-------------------------------------------------------\n");
printf("Prikaz trenutnog sadrzaja liste:\n");
prikazi_listu(glava);
printf("-------------------------------------------------------\n");
printf("Uneti broj koji se trazi: ");
scanf("%d",&broj);

if((pomocni = pretrazi_listu(glava, broj)) == NULL)
    printf("Trazeni broj nije u listi\n");
else
   printf("Trazeni element %d je u listi\n", pomocni->vrednost); 
printf("-------------------------------------------------------\n");
putchar('\n');

glava = oslobodi_listu(glava);


/* Testiranje dodavanja na kraj */
printf("-------------------------------------------------------\n");
printf("------------ Testiranje dodavanja na kraj -------------\n");
do{
printf("-------------------------------------------------------\n");
printf("Prikaz liste:\n");
prikazi_listu(glava);
printf("-------------------------------------------------------\n");
printf("Dodati element na kraj liste (ctrl-D za kraj unosa):\n");
} while(scanf("%d",&broj) > 0 &&  
                   (glava = dodaj_na_kraj_liste(glava, broj)));
printf("-------------------------------------------------------\n");
putchar('\n');


/* Testiranje brisanja elemenata */
printf("-------------------------------------------------------\n");
printf("--------------- Testiranje brisanja -------------------\n");
printf("-------------------------------------------------------\n");
printf("Prikaz trenutnog sadrzaja liste:\n");
prikazi_listu(glava);
printf("-------------------------------------------------------\n");
printf("Uneti broj koji se brise: ");
scanf("%d", &broj);

glava = obrisi_element(glava, broj);
printf("-------------------------------------------------------\n");
printf("Lista nakon izbacivanja:\n");
prikazi_listu(glava);
printf("-------------------------------------------------------\n");
putchar('\n');

glava = oslobodi_listu(glava);

/* Testiranje sortiranog dodavanja */
printf("-------------------------------------------------------\n");
printf("----------- Testiranje sortiranog dodavanja -----------\n");
do{
printf("-------------------------------------------------------\n");
printf("Prikaz liste:\n");
prikazi_listu(glava);
printf("-------------------------------------------------------\n");
printf("Dodati element sortirano (ctrl-D za kraj unosa):\n");
} while(scanf("%d",&broj) > 0 &&  
              (glava = dodaj_sortirano(glava, broj)));
printf("-------------------------------------------------------\n");
putchar('\n');

glava = oslobodi_listu(glava);

return 0;

}
