#include <stdio.h>
#include <stdlib.h>


/* NAPOMENA: U ovom primeru demonstriramo dinamicku alokaciju 
   matrice. Primenjujemo sledeci postupak:

   1) Definisemo pokazivac na pokazivac na int:

    int **p;

   Ovaj pokazivac ce nam sluziti da cuva adresu prvog u nizu
   dinamicki alociranih pokazivaca na int-ove.

   2) Dinamicki alociramo niz od m pokazivaca na int-ove, i
   adresu prvog u nizu smestamo u promenljivu p:

     p = malloc(sizeof(int*) * m));

   (primetimo da je ime tipa int * -- pokazivac na int). Ovi
   pokazivaci ce nam sluziti da pokazuju na prve elemente nizova
   int-ova koji predstavljaju dinamicki alocirane vrste. 

   3) Svaku vrstu alociramo posebnim malloc-om, i povratnu adresu 
   smestamo u i-ti pokazivac u malopre alociranom nizu pokazivaca. 

    for(i = 0; i < m; i++)
      p[i] = malloc(sizeof(int) * n);

   Primetimo da nizovi int-ova koji se alociraju nisu morali biti
   jednakih dimenzija (ne moraju svi biti duzine n, kao sto je 
   ovde receno). Ovo moze da bude korisno, ako znamo da ce u nekoj
   vrsti biti korisceno samo nekoliko prvih elemenata, tada mozemo
   alocirati manje za tu vrstu, i tako ustedeti prostor.

   4) U toku rada se elementima ovako alocirane matrice i dalje moze
   pristupati sa p[i][j] -- p[i] je i-ti pokazivac u nizu, a kako
   on pokazuje na pocetni element u i-toj vrsti, tada je p[i][j]
   upravo j-ti element u i-toj vrsti. 

   5) Dealokacija se sastoji u brisanju svih vrsta, nakon cega se 
   obrise i niz pokazivaca (dakle, dealokacija ide u suprotnom redosledu
   od redosleda alokacije):

   for(i = 0; i < m; i++)
    free(p[i]);
   free(p); 
*/

int main()
{
  int **p;
  int m, n;
  int i, j; 

  printf("Uneti broj vrsta matrice: ");
  scanf("%d", &m);
  printf("Unesite broj kolona matrice: ");
  scanf("%d", &n);

  /* Alociramo m pokazivaca na vrste matrice */
  if((p = malloc(sizeof(int*) * m)) == NULL)
  {
     fprintf(stderr, "malloc() greska\n");
     exit(1);
  }

  /* Alociramo m vrsta od po n int-ova */
  for(i = 0; i < m; i++)
    if((p[i] = malloc(sizeof(int) * n)) == NULL)
    {
       fprintf(stderr, "malloc() greska\n");
       exit(1);
    }

  /* Postavljamo p[i][j] na vrednost abs(i - j) */
  for(i = 0; i < m ; i++)
   for(j = 0; j < n; j++)
     p[i][j] = i - j >=0 ? i - j : j - i;

   
   /* Ispis matrice */
   for(i = 0; i < m ; i++)
   {
      for(j = 0; j < n; j++)
        printf("%3d ", p[i][j]);
      putchar('\n');
   }

  /* Oslobadjanje vrsta matrice */
  for(i = 0; i < m; i++)
    free(p[i]);

  /* Oslobadjanje niza pokazivaca */
  free(p);

  return 0;
}
