#include <stdio.h>
#include <stdlib.h>

/* NAPOMENA: Primer demonstrira alokaciju niza elemenata.
   Dovoljno je alocirati n * sizeof(T) bajtova, gde je
   T tip elemenata niza. Povratnu adresu malloc()-a treba
   pretvoriti iz void * u T *, kako bismo dobili pokazivac
   koji pokazuje na prvi element niza tipa T. Na dalje se
   elementima moze pristupati potpuno istovetno kao da nam
   je dato ime niza (koje se, kao sto znamo tako i ponasa,
   kao pokazivac na element tipa T koji je prvi u nizu).
*/

int main()
{
  int * p; 
  int i, n;
  int s;

  /* Unosimo dimenziju niza. Ova vrednost nije ogranicena 
     bilo kakvom konstantom, kao sto je to ranije bio slucaj 
     kada su nizovi bili alocirani staticki, pa je njihova
     dimenzija bila unapred ogranicena definisanim prostorom. */
  printf("Uneti dimenziju niza: ");
  scanf("%d", &n);

  /* Alociramo prostor za n int-ova */
  if((p = malloc(sizeof(int) * n)) == NULL)
   {
     fprintf(stderr, "malloc() greska!\n");
     exit(1);
   }

  /* Od ovog trenutka mozemo da koristimo pokazivac p kao da je
     ime niza, tj. i-tom elementu se moze pristupiti sa p[i] */

  /* Unosimo elemente niza */
  printf("Uneti elemente niza:\n");
  for(i = 0;  i < n;  i++)
   scanf("%d", &p[i]);

  
  /* Sumiramo elemente niza */
  for(i = 0, s = 0; i < n; i++)
    {
      s += p[i];
    }
  
  printf("Suma elemenata niza je: %d\n", s);

  /* Oslobadjamo prostor */
  free(p);

  return 0;
}
