/* Program ispituje da li u nizu stringova postoje dva koja su identicna */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_STR 100
#define MAX_STR_LEN 100

/* Funkcija poredi pokazivace na karaktere. Relacija
   poretka definisana je na sledeci nacin:
        p1 < p2 <==> string na koji pokazuje p1 je 
         leksikografski manji od stringa na koji 
         pokazuje p2.
*/
int char_p_compare (const void *p1, const void *p2)
{
  /* Konvertujemo genericke pokazivace u pokazivace
     na pokazivace na karaktere, koje zatim derefe-
     renciramo dobivsi pritom pokazivace na karaktere.
     Ovi se pokazivaci predaju funkciji strcmp() koja
     uporedjuje stringove na koje ovi pokazivaci 
     pokazuju */
  return strcmp (*(char **) p1, *(char **) p2);
}

/* glavni program */
int
main (int argc, char **argv)
{

  int n, i;
  char str[MAX_STR][MAX_STR_LEN];
  char *str_p[MAX_STR];


  /* Osim niza nizova karaktera imamo i niz
     pokazivaca na karaktere (tj. pokazivaca
     na stringove). Sortiranje vrsimo tako
     sto premestamo pokazivace, a ne kopiramo
     same stringove. Ovo je efikasnije resenje.
   */

/* unosimo broj elemenata */
  printf ("Unesite broj stringova: ");
  scanf ("%d", &n);


/* unosimo redom stringove i inicijalizujemo pokazivace */
  for (i = 0; i < n; i++)
    {
      scanf ("%20s", str[i]);
      str_p[i] = str[i];
    }

/* sortiramo niz stringova. Tacnije, sortiramo niz
   pokazivaca na stringove, tako da stringovi na
   koje oni redom pokazuju budu u rastucem poretku. 
   Poredjenje pokazivaca vrsi se funkcijom 
   char_p_compare(), dok se prilikom premestanja 
   elemenata premestaju pokazivaci, a ne nizovi 
   karaktera, cime se citav proces sortiranja cini
   efikasnijim.
*/
  qsort (str_p, n, sizeof (char *), &char_p_compare);


/* Nakon sortiranja, gde god nam je potreban i-ti 
   string po leksikografskom poretku, mi koristimo
   str_p[i], s obzirom da su pokazivaci sortirani,
   a ne sami stringovi. str[i] ce medjutim, dati 
   onaj string koji je unet i-ti po redu, jer same 
   stringove nismo premestali */


/* S obzirom da je niz sortiran, ako postoje
   dva identicna stringa, oni moraju biti 
   susedni. Zato je dovoljno kretati se kroz
   niz stringova i porediti susedna dva elementa.
   Ako pronadjemo dva susedna identicna stringa
   izlazimo iz petlje. 
*/
  for (i = 1; i < n; i++)
    if (strcmp (str_p[i - 1], str_p[i]) == 0)
      break;			/* napustamo petlju */

/* ako je i<n, tada smo izasli ranije iz petlje,
   tj. pronasli smo identicne susede. */
  if (i < n)
    printf ("Postoje identicni stringovi: %s\n", str_p[i]);
  else
    printf ("Ne postoje identicni stringovi\n");


  return 0;
}
