/* Program utvrdjuje da li u nizu stringova postoje dva koja su identicna. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_STR 100
#define MAX_STR_LEN 100


/* Funkcija koja dva niza od po 100 karaktera poredi,
   tako sto poredi stringove koji su u njima 
   sadrzani */
int
char_array_compare (const void *s, const void *t)
{
  /* Konvertujemo genericke pokazivace u pokazivace
     na nizove od MAX_STR_LEN karaktera */
  char (*ps)[MAX_STR_LEN] = (char (*)[MAX_STR_LEN]) s;
  char (*pt)[MAX_STR_LEN] = (char (*)[MAX_STR_LEN]) t;

  /* Dereferenciranjem pokazivaca na nizove dobijamo
     same nizove, koji se ponasaju kao adrese svojih
     prvih elemenata. Drugim recima, funkciji strcmp()
     predajemo pokazivace na prve karaktere u stringovima
     koji su sadrzani u nizovima koji se porede */
  return strcmp (*ps, *pt);

}

/* glavni program */
int
main (int argc, char **argv)
{

  int n, i;
  char str[MAX_STR][MAX_STR_LEN];

/* Unosimo broj elemenata */
  printf ("Unesite broj stringova: ");
  scanf ("%d", &n);

/* Unosimo redom stringove */
  for (i = 0; i < n; i++)
    scanf ("%s", str[i]);

/* Sortiramo niz nizova karaktera.
   Umesto sizeof(str[0]) moglo je da
   stoji sizeof(char [MAX_STR_LEN]). 
   Poredjenje nizova karaktera vrsi se
   char_array_compare() funkcijom. 
   Prilikom sortiranja funkcija qsort() 
   premesta citave nizove od po 100 
   karaktera, sto nije preterano efikasno.
*/
  qsort (str, n, sizeof (str[0]), &char_array_compare);

/* S obzirom da je niz sortiran, ako postoje
   dva identicna stringa, oni moraju biti 
   susedni. Zato je dovoljno kretati se kroz
   niz stringova i porediti susedna dva elementa.
   Ako pronadjemo dva susedna identicna stringa
   izlazimo iz petlje.
*/
  for (i = 1; i < n; i++)
    if (strcmp (str[i - 1], str[i]) == 0)
      break;	/* napustamo petlju */

/* Ako je i<n, tada smo izasli ranije iz petlje,
   tj. pronasli smo identicne susede. */
  if (i < n)
    printf ("Postoje identicni stringovi: %s\n", str[i]);
  else
    printf ("Ne postoje identicni stringovi\n");


  return 0;
}
