#include <stdio.h>
#include <stdlib.h>

#define MAX 100 

/* NAPOMENA: Program demonstrira upotrebu funkcija qsort()
   i bsearch(). Ove funkcije su definisane u standardnoj
   biblioteci i za njihovo koriscenje dovoljno je ukljuciti
   zaglavlje stdlib.h. 
   Funkcija qsort() vrsi sortiranje niza metodom sortiranja
   razdvajanjem. Deklaracija ove funkcije je sledeca:

   void qsort(void *b, int n, int s,
              int(*comp)(const void *, const void *));
   
   Prvi argument je adresa pocetka niza koji se sortira. S 
   obzirom da se ne zna tacan tip elemenata niza, koristi 
   se genericki pokazivac (void *, pogledati napomenu dole).
   Drugi argument je broj elemenata niza, a treci velicina 
   svakog od elemenata niza. Poslednji argument je pokazivac
   na funkciju poredjenja. Ova funkcija treba da prihvata 
   adrese elemenata niza koji se porede, i da vraca >0 ako
   je prvi element veci, <0 ako je prvi element manji, a 
   vraca 0 ako su elementi koji se porede jednaki. Na ovaj
   nacin se moze sortirati bilo koji niz, dovoljno je da je 
   na neki nacin funkcijom poredjenja definisan potpuni 
   poredak medju elementima niza. Argumenti funkcije 
   poredjenja su takodje genericki pokazivaci, opet zato sto
   ne znamo tacno kog su tipa elementi niza. Ovi pokazivaci
   su jos kvalifikovani kljucnom recju const. O ovome videti
   napomenu dole.

   Funkcija bsearch() vrsi pretrazivanje sortiranog niza 
   metodom binarne pretrage. Funkcija ima sledecu deklaraciju:

   void *bsearch(const void *x, const void *b, int n,
              int s, int (*comp)(const void *, const void *));

   Prvi argument je pokazivac na podatak koji se trazi u nizu.
   Drugi argument je adresa pocetka niza, treci velicina 
   niza, a cetvrti velicina elementa niza.  Poslednji argument 
   je pokazivac na funkciju poredjenja koja definise poredak u 
   skladu sa kojim je sortiran niz. Funkcija vraca adresu 
   elementa u nizu koji je jednak trazenom elementu, ili NULL 
   ukoliko element nije pronadjen.

   Osim ovih funkcija, postoje jos i funkcije za linearnu pretragu. 
   U pitanju su funkcije lsearch() i lfind(). Funkcija lsearch():

   void *lsearch(const void *x, void *b, int *n,
              int s, int (*comp)(const void *, const void *));

   ima potpuno iste argumente kao i bsearch() -- jedina razlika je u tome
   sto se kao treci argument ne predaje duzina niza vec adresa celobrojne
   promenljive u kojoj se nalazi duzina niza. Ovo je zato sto funkcija 
   lsearch() ukoliko linearnom pretragom ne pronadje element koji se 
   trazi, umece trazeni element na kraj niza, a duzinu niza uvecava za 
   jedan (sto cini tako sto promenljivoj pozivajuce funkcije pristupa 
   preko pokazivaca i menja je). Funkcija za uporedjivanja elemenata
   na koju pokazuje pokazivac comp treba da zadovoljava ista pravila
   kao i kod prethodnih funkcija. Medjutim, s obzirom da se kod linearne
   pretrage koristi iskljucivo poredjenje na jednakost, dovoljno je 
   da funkcija za uporedjivanje vraca 0 ako su objekti koji se uporedjuju
   jednaki, a razlicito od nule u suprotnom.

   Funkcija:

   void *lfind(const void *x, void *b, int *n,
              int s, int (*comp)(const void *, const void *));

   funkcionise isto kao i lsearch(), s tom razlikom sto ne umece novi element
   u slucaju neuspesne pretrage, vec vraca NULL (f-ja lsearch() u slucaju 
   neuspesne pretrage umece trazeni element na kraj i vraca njegovu adresu).

*/

/* NAPOMENA: Pokazivac na void je pokazivac koji moze sadrzati
   adresu bilo kog podatka u memoriji. Svaki pokazivac se moze
   bez konverzije dodeliti ovom pokazivacu, kao i obrnuto. 
   Moze se koristiti za cuvanje adrese  podatka za koji unapred 
   ne znamo kog ce biti tipa. Njegova glavna karakteristika je
   da se ne moze dereferencirati, zato sto se ne zna kog je tipa
   ono na sta on pokazuje. Programer mora na drugi nacin da utvrdi 
   kog je tipa podatak na toj adresi, pa da najpre konvertuje
   void pokazivac u odgovarajuci tip pokazivaca, a zatim da ga
   tako konvertovanog dereferencira. 
*/

/* NAPOMENA: Kljucna rec const u programskom jeziku C sluzi za
   definisanje konstanti. Ako napisemo:

   const int a = 2;

   tada se u daljem toku programa promenljivoj a ne moze dodeljivati
   vrednost. Za razliku od konstanti definisanih define direktivom
   ova konstanta ima jasno definisan tip koji prevodilac proverava
   prilikom upotrebe. 

   Treba naglasiti, medjutim, da ako se napise:

   const int * p = &a;
 
   tada se const ne odnosi na promenljivu p, vec na podatak tipa int
   na koji p pokazuje. Dakle, nije pokazivac konstantan, vec on 
   pokazuje na konstantan podatak. Na primer:

   int b;
   p = &b;

   je dozvoljeno, ali:

   *p = 4;

   nije dozvoljeno, zato sto je p pokazivac na konstantan int. Ovo se
   moze razumeti tako sto se deklaracija procita sa desna u levo:

   const int * p;  -- p je pokazivac na int koji je konstantan 

   Slicno bi bilo i ako napisemo:

   int const * p; -- p je pokazivac na konstantan int.

   Medjutim, ako napisemo:

   int * const p; -- p je konstantan pokazivac na int.

   Kombinacija ovoga je:

   const int * const p; -- p je konstantan pokazivac  na int
                           koji je konstantan.

   Dakle, u ovom poslednjem slucaju konstantni su i pokazivac
   i ono na sta on pokazuje.
*/ 


/* Funkcija poredi dva cela broja */
int compare_int(const void *a, const void *b)
{
   /* Konvertujemo void pokazivace u int pokazivace
      koje zatim dereferenciramo, dobijamo int-ove 
      koje oduzimamo i razliku vracamo. */
   return *((int *)a) - *((int *)b); 
}

/* Test program */
int main()
{
   int n, i, x;
   int a[MAX], *p;

   /* Unosimo dimenziju */
   printf("Uneti dimenziju niza: ");
   scanf("%d", &n);

   /* Unosimo elemente niza */
   printf("Uneti elemente niza:\n");
   for(i = 0; i < n; i++)
     scanf("%d", &a[i]);

   /* Sortiramo niz */
   qsort(a, n, sizeof(int), &compare_int);
  
   /* Prikazujemo sortirani niz */
   printf("Sortirani niz:\n");
   for(i = 0; i < n; i++)
     printf("%d ", a[i]);
   putchar('\n');

   /* Unosimo trazeni broj */
   printf("Uneti trazeni broj: ");
   scanf("%d", &x);

   /* Binarna pretraga */
   p = bsearch(&x, a, n, sizeof(int), &compare_int);

   if(p != NULL)
     printf("Element %d pronadjen u nizu\n", *p);
   else
     printf("Element nije pronadjen u nizu\n");

   return 0;
}
