#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX 100

/* Sortiranje niza celih brojeva - QuickSort algoritam */

/* Funkcija menja mesto i-tom i j-tom elementu niza a */
void swap(int a[], int i, int j)
{
  int tmp = a[i];
  a[i] = a[j];
  a[j] = tmp;
}


/* Funkcija sortira deo niza brojeva a izmedju pozicija l i r*/
void quick_sort(int a[], int l, int r)
{
  int i, pivot_position;
  
  /* Izlaz iz rekurzije -- prazan niz */
  if (l >= r)  
    return;         
  

  /* Particionisanje niza. Svi elementi na pozicijama <= pivot_position (izuzev
     same pozicije l) su strogo manji od pivota. Kada se pronadje neki element
     manji od pivota, uvecava se pivot_position i na tu poziciju se premesta
     nadjeni element. Na kraju ce pivot_position zaista biti pozicija na koju
     treba smestiti pivot, jer ce svi elementi levo od te pozicije biti manji
     a desno biti veci ili jednaki od pivota. */
  pivot_position = l;
  for (i = l+1; i <= r; i++)
    if (a[i] < a[l])
      swap(a, ++pivot_position, i);
  
  /* Postavljamo pivot na svoje mesto */
  swap(a, l, pivot_position);
  
  /* Rekurzivno sortiramo elemente manje od pivota */
  quick_sort(a, l, pivot_position - 1);
  /* Rekurzivno sortiramo elemente vece pivota */
  quick_sort(a, pivot_position + 1, r);
}



/* Test program */
int main(int argc, char **argv)
{
  int a[MAX];
  int n, i;
  int x;


  /* Niz brojeva se zadaje na komandnoj liniji */
  for(n = 0; n + 1 < argc && n < MAX; n++)
    a[n] = atoi(argv[n + 1]);

  /* Poziv funkcije */
  quick_sort(a, 0, n - 1);
  
  /* Prikaz niza */
  for(i = 0; i < n; i++)
   printf("%d ", a[i]);
  putchar('\n');
  
  return 0;
}
