#include <stdio.h>
#include <stdlib.h>

/* NAPOMENA: U slucaju da se rekurzijom problem svodi na vise manjih 
   podproblema koji se mogu preklapati, postoji opasnost da se pojedini 
   podproblemi manjih dimenzija resavaju veci broj puta. 
   Npr. fibonacci(20) = fibonacci(19) + fibonacci(18), a fibonacci(19) = 
   fibonacci(18) + fibonacci(17), tj. problem fibonacci(18) se resava
   dva puta!! Problemi manjih dimenzija ce se resavati jos veci broj 
   puta. Resenje za ovaj problem je kombinacija rekurzije sa tzv.
   "dinamickim programiranjem" -- podproblemi se resavaju samo jednom,
   a njihova resenja se pamte u memoriji (obicno u nizovima ili matricama),
   odakle se koriste ako tokom resavanja ponovo budu potrebni. */
   

/* Funkcija izracunava n-ti fibonacijev broj */
int fibonacci(int n)
{
  /* Niz koji cuva resenja podproblema. */
  static int f[50];

  /* Ako je podproblem vec resen, uzimamo gotovo resenje! */
  if(f[n] != 0)
    return f[n];

  /* Izlaz iz rekurzije */
  if(n < 2)
    return f[n] = 1;
  
  /* Rekurzivni pozivi */
  return f[n] = fibonacci(n - 1) + fibonacci(n - 2);
}

/* Test program */
int main()
{

  int n;
  
  scanf("%d", &n);

  printf("%d\n", fibonacci(n));

  return 0;
}
