#include <stdio.h>
#include <stdlib.h>

#define MAX 100

/* NAPOMENA: Primer ilustruje uzajamnu (posrednu) 
   rekurziju. */

/* Funkcija racuna sumu elemenata niza na pozicijama
   0, 2, 4, ... */
int suma_parnih_pozicija(int a[], int n)
{
  /* Deklaracija funkcije -- neophodno kod uzajamne 
     rekurzije. */
  int suma_neparnih_pozicija(int a[], int n);
  
  if(n == 0)
    return 0;
  
  return a[0] + suma_neparnih_pozicija(a + 1, n - 1);
  
}

/* Funkcija racuna sumu elemenata niza na pozicijama
   1, 3, 5, ... */
int suma_neparnih_pozicija(int a[], int n)
{
  if(n == 0)
    return 0;
  
  return suma_parnih_pozicija(a + 1, n - 1);
  
}

/* Test program */
int main(int argc, char **argv)
{
  int a[MAX];
  int n;
  
  /* Niz brojeva se zadaje na komandnoj liniji */
  for(n = 0; n + 1 < argc && n < MAX; n++)
    a[n] = atoi(argv[n + 1]);
  
  printf("Parne: %d\n", suma_parnih_pozicija(a, n));
  printf("Neparne: %d\n", suma_neparnih_pozicija(a, n));
  
  return 0;
}
