#include <stdio.h>

#define MAX 100

/* Funkcija trazi u sortiranom nizu a[] duzine n
   broj x. Vraca indeks pozicije nadjenog elementa
   ili -1, ako element nije pronadjen */
int interpolaciona_pretraga (int a[], int n, int x)
{
  int l = 0;
  int d = n - 1;
  int s;

  /* Dokle god je indeks l levo od indeksa d...  */
  while (l <= d)
    {

      /* Ako je element manji od pocetnog ili veci od poslednjeg
	 clana u delu niza a[l],...,a[d] tada nije u tom delu niza.
	 Ova provera je neophodna, da se ne bi dogodilo da se prilikom 
         izracunavanja indeksa s izadje izvan opsega indeksa [l,d] */
      if(x < a[l] || x > a[d]) 
	return -1;
      /* U suprotnom, x je izmedju a[l] i a[d], pa ako su a[l] i a[d] 
	 jednaki, tada  je jasno da je x jednako ovim vrednostima, pa 
	 vracamo indeks l (ili indeks d, sve jedno je).Ova provera je 
	 neophodna, zato sto bismo inace prilikom izracunavanja s imali 
	 deljenje nulom. */
      else if(a[l] == a[d])	  
	return l;
      

      /* Racunamo sredisnji indeks */
      s = l + ((double)(x - a[l]) / (a[d] - a[l])) * (d - l);
      
     
      /* NAPOMENA: Indeks s je uvek izmedju l i d, ali ce
	 verovatno biti blize trazenoj vrednosti nego da
	 smo prosto uvek uzimali srednji element. Ovo se
	 moze porediti sa pretragom recnika: ako neko trazi
	 rec na slovo 'B', sigurno nece da otvori recnik
	 na polovini, vec verovatno negde blize pocetku. 
      */

      /* Ako je sredisnji element veci od x,
	 tada se x mora nalaziti u levoj polovini niza */
      if (x < a[s])
        d = s - 1;
      /* Ako je sredisnji element manji od x,
	 tada se x mora nalaziti u desnoj polovini niza */
      else if (x > a[s])
        l = s + 1;
      else
	/* Ako je sredisnji element jednak x, 
	   tada smo pronasli x na poziciji s */
        return s; 
      
    }
  
  /* ako nije pronadjen vracamo -1 */
  return -1;
  
}


/* Funkcija sortira niz celih brojeva metodom sortiranja izborom 
   najmanjeg elementa: U prvoj iteraciji se trazi najmanji element 
   u nizu i postavlja se na pocetnu poziciju (zamenom sa elementom
   koji se na toj poziciji nalazio ranije). U sledecoj iteraciji se
   trazi najmanji element medju preostalim elementima, i postavlja se
   na sledecu poziciju, itd. */
void sortiraj (int a[], int n)
{
  int i, j;
  int min;
  int pom;
  
  /* U svakoj iteraciji ove petlje se pronalazi najmanji element medju
     elementima a[i], a[i+1],...,a[n-1], i postavlja se na poziciju i,
     dok se element na pozciji i premesta na poziciju min, na kojoj se
     nalazio najmanji od gore navedenih elemenata. */
  for (i = 0; i < n - 1; i++)
    {
      /* Unutrasnja petlja pronalazi poziciju min, na kojoj se nalazi
         najmanji od elemenata a[i],...,a[n-1]. */
      min = i;
      for (j = i + 1; j < n; j++)
	if (a[j] < a[min])
	  min = j;

      /* Zamena elemenata na pozicijama (i) i min. Ovo se radi samo ako
         su (i) i min razliciti, inace je nepotrebno. */
      if (min != i)
	{
	  pom = a[i];
	  a[i] = a[min];
	  a[min] = pom;
	}
    }
  
}

/* Test program */
int main ()
{

  int a[MAX];
  int n;
  int i;
  int x;
  
  /* Unosimo dimenziju niza */
  printf ("Uneti dimenziju niza: ");
  scanf ("%d", &n);

  /* Unosimo elemente niza */
  printf ("Uneti elemente niza:\n");
  for (i = 0; i < n; i++)
    scanf ("%d", &a[i]);

  /* Sortiramo niz */
  sortiraj (a, n);

  /* Ispisujemo sortirani niz */
  printf ("Niz nakon sortiranja:\n");
  for (i = 0; i < n; i++)
    printf ("%d ", a[i]);
  putchar ('\n');

  /* Unosimo broj koji se trazi */
  printf("Uneti trazeni broj: ");
  scanf("%d", &x);

  /* Pozivamo funkciju interpolaciona_pretraga() */
  i = interpolaciona_pretraga(a, n, x);
  
  /* Prikazujemo rezultat */
  if(i == -1)
    printf("Element nije pronadjen\n");
  else 
    printf("Element pronadjen na poziciji %d\n", i);

  return 0;
}
