#include <stdio.h>

#define MAX 100

/* Funkcija pretrazuje niz celih brojeva duzine n, 
   trazeci u njemu element x. Pretraga se vrsi 
   prostom iteracijom kroz niz. Ako se element pronadje
   funkcija vraca indeks pozicije na kojoj je pronadjen.
   Ovaj indeks je, kao sto znamo, uvek nenegativan. 
   Ako element nije pronadjen u nizu, funkcija vraca 
   -1, kao indikator neuspesne pretrage. */
int linearna_pretraga(int a[], int n, int x)
{
  int i;

  for(i = 0; i < n; i++)
    if(a[i] == x)
      return i;

  return -1;
}


/* Funkcija main */
int main()
{
  int a[MAX];
  int n, i, x;

  /* Unosimo dimenziju niza */
  printf("Uneti dimenziju: ");
  scanf("%d", &n);
  
  /* Unosimo elemente */
  printf("Uneti elemente niza:\n");
  for(i = 0; i < n; i++)
    scanf("%d", &a[i]);

  /* Unosimo broj koji se trazi */
  printf("Uneti element koji se trazi: ");
  scanf("%d", &x);
  
  /* Pretrazujemo niz */
  i = linearna_pretraga(a, n, x);

  /* Ispis poruke */
  if(i == -1)
    printf("Element nije u nizu\n");
  else
    printf("Element je u nizu na poziciji %d\n", i);
  
  return 0;
}
