/* Zadatak ucitava informacije o studentima iz datoteke cije se ime zadaje sa
   komandne linije, i koja je u formatu:
   
   n
   prezime1 ime1 smer1 prosek1
   prezime2 ime2 smer2 prosek2
   ...
   prezimen imen smern prosekn

   Studenti se sortiraju leksikografski po prezimenima i imenima, a zatim se
   njihovi podaci tako sortirani ispisuju na izlaz, ili u izlazni fajl, ako
   je njegovo ime zadato na komandnoj liniji. */

#include <stdio.h>
#include <string.h>


#define MAX_IME 20
#define MAX_PREZIME 30
#define MAX_SMER 10

#define MAX_STUDENATA 100


/* Struktura koja predstavlja informacije o studentu */
typedef struct student {

  char ime[MAX_IME];
  char prezime[MAX_PREZIME];
  char smer[MAX_SMER];
  double prosek;
  
} Student;


/* Funkcija uporedjuje dva studenta po leksikografskom poretku
   njihovih imena i prezimena. Funkcija vraca vrednost manju od 
   nule ako je prvi student "manji" od drugog, vrednost vecu
   od nule ako je prvi student "veci" od drugog, dok nulu vraca
   ako se studenti zovu isto. */
int uporedi(Student *s, Student *p)
{
  int t;

  /* Najpre poredimo prezimena. Ako su prezimena ista, onda poredimo
     i imena. */
  if((t = strcmp(s->prezime, p->prezime)) != 0)
    return t;
  else
    return strcmp(s->ime, p->ime);
}


/* Funkcija sortira niz studenata u leksikografskom poretku */
void sortiraj(Student studenti[], int n)
{
  int i, j;
  int min;
  Student pom;
 
  /* Studenti se porede funkcijom uporedi(). Zamena elemenata
     niza se obavlja na uobicajen nacin, zato sto je dodela
     struktura legitimna operacija. */
 
  for (i = 0; i < n - 1; i++)
    {
      min = i;
      for (j = i + 1; j < n; j++)
	if (uporedi(&studenti[j], &studenti[min]) < 0)
	  min = j;
      
      if (min != i)
	{
	  pom = studenti[i];
	  studenti[i] = studenti[min];
	  studenti[min] = pom;
	}
    }
}

/* NAPOMENA: Funkcije fprintf() i fscanf() su potpuno ekvivalentne funkcijama
   printf() i scanf(), osim sto umesto standardnog izlaza (ulaza) koriste fajl
   ciji se pokazivac predaje kao prvi argument:

   fscanf(FILE *in, char *format, ...);
   fprintf(FILE *out, char *format, ...); 

   Primetimo jos da je:

   printf(format, ...) <=> fprintf(stdout, format, ...);
   scanf(format, ...) <=> fscanf(stdin, format, ...);
*/

/* Funkcija ucitava podatke o studentu */
void ucitaj(FILE *in, Student *s)
{
  fscanf(in, "%s", s->prezime);
  fscanf(in, "%s", s->ime);
  fscanf(in, "%s", s->smer);
  fscanf(in, "%lf", &s->prosek);
}

/* Ispisujemo informacije o studentu */
void ispisi(FILE *out, Student *s)
{
  fprintf(out, "%s %s %s %f\n", s->prezime, s->ime, s->smer, s->prosek);  
}

/* Funkcija main */
int main (int argc, char ** argv)
{

  int n, i;
  FILE  *in = stdin, *out = stdout;
  Student studenti[MAX_STUDENATA];


  /* Ako je korisnik uneo ime ulaznog fajla...*/
  if(argc > 1)
    if((in = fopen(argv[1], "r")) == NULL)
      {
	fprintf(stderr, "Greska prilikom otvaranja fajla!\n");
	return 1;
      }
  
  /* Ako je korisnik uneo i ime izlaznog fajla...*/
  if(argc > 2)
    if((out = fopen(argv[2], "w")) == NULL)
      {
	fprintf(stderr, "Greska prilikom otvaranja fajla!\n");
	return 1;
      }
  
  /* Ucitavamo broj studenata */
  fscanf(in, "%d", &n);
  
  /* Ucitavamo informacije o studentima */
  for(i = 0; i < n;  i++)
    ucitaj(in, &studenti[i]);
  
  /* Sortiramo niz studenata */
  sortiraj(studenti, n);

  /* Ispisujemo niz studenata */
  for(i = 0; i < n;  i++)
    ispisi(out, &studenti[i]);

  return 0;
}
