/* Program prikazuje na izlazu argumente komandne linije koristeci najpre
   nizovsku, a zatim i pokazivacku sintaksu. */

#include <stdio.h>

/* NAPOMENA: Prilikom pozivanja programa iz komandne linije
   moguce je navesti odredjene opcije i argumente, koje program
   koristi u svom radu. Npr, mozemo pozvati program na sledeci
   nacin:
   ./primer ulaz.txt izlaz.txt

   zeleci da program iskopira fajl ulaz.txt u fajl izlaz.txt.
   Potrebno je da postoji mehanizam da program iznutra pristupi
   stringovima koje je korisnik naveo prilikom poziva programa.
   U C-u se to ostvaruje na sledeci nacin. Definisemo parametre
   funkcije main:
   -- int argc -- ovaj parametar prilikom pokretanja programa 
                  dobija vrednost broja argumenata koje je korisnik
                  prilikom poziva naveo. Pri tom se i ime programa
                  broji kao argument komandne linije. U gornjem 
                  primeru ce argc biti postavljeno na 3.
   -- char **argv -- pokazivac na pokazivac na char koji sadrzi adresu
                  prvog u nizu pokazivaca na karaktere. Svaki od tih 
                  pokazivaca na karaktere sadrzi adresu odgovarajuceg
                  stringa koji sadrzi argument komandne linije. Npr.
                  u gornjem primeru, argv[0] ce nam pokazivati na
                  string "./primer", argv[1] ce nam pokazivati na
                  string "ulaz.txt", argv[2] ce nam pokazivati na
                  string "izlaz.txt". 

   Dakle, niz pokazivaca na ciji prvi clan pokazuje argv je duzine upravo
   argc. Sledi primer koji demonstrira kako se moze pristupati argumentima
   komandne linije. */


int main(int argc, char **argv)
{
  int i;

  /* Koriscenje nizovske sintakse */
  for(i = 0; i < argc; i++)
    printf("argv[%d]: %s\n", i, argv[i]);

  /* Koriscenje pokazivacke sintakse */
  for(; argc ; argc--)
    printf("%s ",  *argv++);
  
  putchar('\n');
  
  return 0;
}
