/* Program kopira jedan fajl u drugi. Imena ulaznog i izlaznog fajla
   se zadaju interaktivno. */

#include <stdio.h>
  
#define MAX_IME 1024

/* NAPOMENA:
   U C-u se sa fajlovima barata na sledeci nacin:
   - u standardnoj biblioteci postoji definisana struktura:
   typedef struct {
   ....
   } FILE;

   koja sadrzi sve informacije vezane za otvoreni fajl. Ove
   informacije su platformski zavisne, i nama nisu od znacaja.
   Njima barataju funkcije standarnde biblioteke.
   - Fajl se otvara funkcijom:
   
   FILE * fopen(char *ime, char *nacin);

   Ova funkcija prihvata string sa putanjom do fajla, kao i 
   string koji definise nacin rada sa fajlom. Moze biti:

   "r"  -- fajl se otvara za citanje (mora da postoji)
   "w"  -- fajl se otvara za pisanje (kreira se ako ne postoji,
           a ako postoji, njegov sadrzaj se brise)
   "a"  -- fajl se otvara za dopisivanje (kreira se ako ne postoji.
           Prilikom svakog pisanja sadrzaj se dodaje na kraj fajla).
   
   Funkcija fopen() vraca pokazivac na FILE strukturu koja je 
   povezana sa otvorenim fajlom. Od tog trenutka se baratanje sa
   otvorenim fajlom sastoji u tome da se funkcijama standardne 
   biblioteke prosledi ovaj pokazivac kao argument. Ostalo obavlja
   biblioteka za nas. 
   - Ako fajl nije uspesno otvoren, povratna vrednost je NULL. Ova
   konstanta je definisana u stdio.h zaglavlju na sledeci nacin:

   #define NULL 0

   Dakle, u pitanju je nula. Uobicajeno je da se ova konstanta koristi
   za pokazivace koji imaju vrednost nula (tj. ne pokazuju ni na sta).
   Prilikom svakog otvaranja fajla, treba proveriti da li je nastupila
   greska.
   
   - Nakon zavrsetka rada sa fajlom, treba ga zatvoriti:
   
   fclose(f);

   gde je f FILE pokazivac. Prilikom zavrsetka rada programa, svi fajlovi
   se automatski zatvaraju.
*/

int main()
{
  FILE *in, *out;
  char ime_fajla[MAX_IME];
  int c;
  
  /* Ucitavamo ime ulaznog fajla */
  printf("Uneti ime ulaznog fajla: ");
  scanf("%s", ime_fajla);


  /* Otvaramo ulazni fajl za citanje */
  in = fopen(ime_fajla, "r");
  
  /* Ako je nastupila greska (fajl ne postoji ili nemamo
     pravo citanja) prekidamo program. */
  if(in == NULL)
    {
      printf("Greska prilikom otvaranja fajla\n");
      return 1;
    }


  /* Ucitavamo ime izlaznog fajla */
  printf("Uneti ime izlaznog fajla: ");
  scanf("%s", ime_fajla);

  /* Otvaramo izlazni fajl za pisanje */
  out = fopen(ime_fajla, "w");
  
  /* Ako je nastupila greska (nemamo pravo pisanja, ili
     ne mozemo da kreiramo fajl) prekidamo program */
  if(out == NULL)
    {
      printf("Greska prilikom otvaranja fajla\n");
      return 1;
    }

  /* NAPOMENA: Funkcija:
     
     int fgetc(FILE *f);

     ucitava jedan karakter iz fajla na koji pokazuje f, 
     i vraca njegov ASCII kod kao povratnu vrednost. Ako 
     je nastupio kraj fajla, vraca EOF.

     Funkcija:

     int fputc(int c, FILE *f);

     upisuje karakter c u fajl na koji pokazuje f. Vraca c.
     
  */

  /* Prepisujemo ulazni fajl u izlazni */
  while((c = fgetc(in)) != EOF)
    fputc(c, out);
  
  
  /* Zatvaramo fajlove */
  fclose(in);
  fclose(out);

  /* NAPOMENA: Standardni ulaz i izlaz se u C-u takodje
     svodi na ulaz i izlaz fajova. Prilikom pokretanja
     programa se automatski otvaraju tri fajla, kojima
     se dodeljuju sledeci globalni FILE pokazivaci:
     
     -- stdin -- standardni ulaz (povezan sa tastaturom)
     -- stdout -- standardni izlaz (povezan sa ekranom)
     -- stderr -- standardni izlaz za greske (povezan 
        sa ekranom)
     
    Imajuci ovo u vidu, jasno je da vazi:

    getchar() <=> fgetc(stdin)
    putchar(c) <=> fputc(c, stdout);
  */

  return 0;
}
