#include <stdio.h>
#include <stdlib.h>


/* Primer demonstrira sortiranje niza pomocu binarnog stabla. Elementi niza
   se redom prvo smeste u binarno stablo pretrage, a zatim se elementi
   "pokupe" iz stabla obilazeci ga sa leva u desno (tj. u rastucem poretku).
   Vremenska slozenost ovakvog algoritma je u ekvivalentna quick_sort()-u.
   Prostorna slozenost je nesto veca, jer sortiranje nije "u mestu", vec se
   koristi pomocna struktura -- binarno stablo.
*/

#define MAX 1000

/* Struktura koja predstavlja cvor stabla */
typedef struct cvor {
  
  int vrednost;   
  struct cvor * levi; 
  struct cvor * desni; 
  
} Cvor;

/* Funkcija kreira novi cvor */
Cvor * napravi_cvor (int broj)
{
  
  Cvor * novi = (Cvor *) malloc (sizeof(Cvor));
  
  if (novi == NULL)
    {
      fprintf (stderr,"malloc() greska\n");
      exit (1);
    }
  
  novi->vrednost = broj;
  novi->levi = NULL;
  novi->desni = NULL;
  
  return novi;
  
}

/* Funkcija dodaje novu vrednost u stablo. Dozvoljava 
   ponavljanje vrednosti  u stablu -- levo se dodaju
   manje vrednosti, a desno vece ili jednake. */
Cvor * dodaj_u_stablo (Cvor * koren, int broj)
{
  
  if (koren == NULL)
    return napravi_cvor (broj);
  
  
  if (koren->vrednost <= broj)
    koren->desni = dodaj_u_stablo (koren->desni, broj);
  
  else if (koren->vrednost > broj)
    koren->levi = dodaj_u_stablo (koren->levi, broj);

  return koren;
  
}

/* Funkcija oslobadja stablo */
void oslobodi_stablo (Cvor *koren)
{
  
  if(koren == NULL)
    return;
  
  oslobodi_stablo (koren->levi);
  oslobodi_stablo (koren->desni);
  free(koren);
  
}

/* Funkcija obilazi stablo sa leva u desno i
   vrednosti cvorova smesta u niz. Funkcija 
   vraca broj vrednosti koje su smestene u niz. */
int kreiraj_niz(Cvor * koren, int a[])
{
  int r, s;

  if(koren == NULL)
    return 0;

  r = kreiraj_niz(koren->levi, a);
  
  a[r] = koren->vrednost;
  
  s = kreiraj_niz(koren->desni, a + r + 1);

  return r + s + 1;

}

/* Funkcija sortira niz tako sto najpre elemente 
   niza smesti u stablo, a zatim kreira novi niz 
   prolazeci kroz stablo sa leva u desno. */
void sortiraj(int a[], int n)
{
  int i;
  Cvor * koren  = NULL;
  
  for(i = 0; i < n; i++)
    koren = dodaj_u_stablo(koren, a[i]);
  
  kreiraj_niz(koren, a);
  
  oslobodi_stablo(koren);
  
}

/* Test program */
int main()
{
  int a[MAX];
  int n, i;

  printf("Uneti dimenziju niza: ");
  scanf("%d", &n);
  
  printf("Uneti elemente niza: ");
  for(i = 0; i < n; i++)
    scanf("%d", &a[i]);

  printf("Niz pre sortiranja:\n");
  for(i = 0; i < n; i++)
    printf("%d ", a[i]);
  printf("\n");

  sortiraj(a, n);

  printf("Niz nakon sortiranja:\n");
  for(i = 0; i < n; i++)
    printf("%d ", a[i]);
  printf("\n");
  
  
  return 0;
}
