#include <stdio.h>
#include <stdlib.h>

/* Primer demonstrira jednostavne funkcije koje izracunavaju neke
   karakteristike stabla, poput visine stabla, broja cvorova i
   broja listova u stablu */
   


/* Struktura koja predstavlja cvor stabla */
typedef struct cvor {
  
  int vrednost;   
  struct cvor * levi; 
  struct cvor * desni; 
  
} Cvor;

/* Funkcija kreira novi cvor */
Cvor * napravi_cvor (int broj)
{
  
  Cvor * novi = (Cvor *) malloc (sizeof(Cvor));
  
  if (novi == NULL)
    {
      fprintf (stderr,"malloc() greska\n");
      exit (1);
    }
  
  novi->vrednost = broj;
  novi->levi = NULL;
  novi->desni = NULL;
  
  return novi;
  
}

/* Funkcija dodaje novu vrednost u stablo. */
Cvor * dodaj_u_stablo (Cvor * koren, int broj)
{
  
  if (koren == NULL)
    return napravi_cvor (broj);
  
  
  if (koren->vrednost < broj)
    koren->desni = dodaj_u_stablo (koren->desni, broj);
  
  else if (koren->vrednost > broj)
    koren->levi = dodaj_u_stablo (koren->levi, broj);

  return koren;
  
}

/* Funkcija oslobadja stablo */
void oslobodi_stablo (Cvor *koren)
{
  
  if(koren == NULL)
    return;
  
  oslobodi_stablo (koren->levi);
  oslobodi_stablo (koren->desni);
  free(koren);
  
}

int broj_cvorova(Cvor * koren)
{
  if(koren == NULL)
    return 0;

  return broj_cvorova(koren->levi) + 
    broj_cvorova(koren->desni) + 1;
  
}

int broj_listova(Cvor * koren)
{
  if(koren == NULL)
    return 0;

  if(koren->levi == NULL && koren->desni == NULL)
    return 1;
  else
    return broj_listova(koren->levi) + 
      broj_listova(koren->desni);
}

int visina_stabla(Cvor * koren)
{
  int l, d;

  if(koren == NULL)
    return -1;

  l = visina_stabla(koren->levi);
  d = visina_stabla(koren->desni);
  
  return (l > d ? l : d) + 1;

}


/* Test program */
int main()
{

  Cvor * koren = NULL;
  int x;

  while(scanf("%d", &x) == 1)
    koren = dodaj_u_stablo(koren, x);

  printf("Broj cvorova: %d\n", broj_cvorova(koren));
  printf ("Broj listova: %d\n", broj_listova(koren));
  printf("Visina stabla: %d\n", visina_stabla(koren));

  oslobodi_stablo(koren);
  
  return 0;
}
