
/* Definicija tipa "Racionalan" */
typedef struct {

  int p; /* brojilac */
  int q; /* imenilac */

} Racionalan;

/* Funkcija racuna zbir dva racionalna broja */
Racionalan saberi(Racionalan * a, Racionalan * b)
{
  Racionalan s;
  int d;

  s.p = a->p * b->q + b->p * a->q;
  s.q = a->q * b->q;

  d = nzd(s.p, s.q);
  s.p /= d;
  s.q /= d;

  return s;
}

/* Funkcija racuna nzd dva pozitivna broja
   primenom Euklidovog algoritma. */
int nzd(int n, int m)
{
   int r;

   /* Dokle god je m!=0, svodimo nzd(n,m) na
      nzd(m,r), gde je r = n % m. */
   while(m)
   {
      r = n % m;
      n = m;
      m = r;
   }
   /* Nakon sto je m postalo 0, jasno je da je
      nzd(n,0) = n */
   return n;
}

/* Funkcija vraca 1 ako su dva racionalna broja jednaka, 
   u suprotnom vraca 0 */
int jednaki(Racionalan * a, Racionalan * b)
{
  return a->p * b->q == a->q * b->p;
}
