
/* Funkcija kreira presek dva rastuca niza a i b i rezultat smesta u 
   niz c (takodje u rastucem radosledu). Funkcija vraca broj elemenata 
   preseka */
int kreiraj_presek(int a[], int n_a, int b[], int n_b, int c[])
{
   int i = 0, j = 0, k = 0;

   /* Dokle god ima elemenata u oba niza... */
   while (i < n_a && j < n_b)
    {
        /* Ako su jednaki, ubacujemo vrednost u presek, 
           i prelazimo na sledece elemente u oba niza. */
        if(a[i] == b[j])
         {
            c[k++] = a[i];
            i++;
            j++;
         }
        /* Ako je element niza a manji, tada u tom nizu prelazimo
           na sledeci element */
        else if(a[i] < b[j])
           i++;
        /* Ako je element niza b manji, tada u tom nizu prelazimo
           na sledeci element */
        else
           j++;
    }
   /* Vracamo broj elemenata preseka */
   return k;

}

/* NAPOMENA: Sledi alternativna verzija funkcije 
   za racunanje preseka. */

/* Funkcija kreira presek dva rastuca niza a i b i rezultat smesta u 
   niz c (takodje u rastucem radosledu). Funkcija vraca broj elemenata 
   preseka */
int kreiraj_presek_2 (int a[], int n_a, int b[], int n_b, int c[])
{
  int i, j = 0, k = 0;

/* za svaki element niza a...*/
  for (i = 0; i < n_a; i++)
    {

/* Preskacemo sve elemente niza b koji
   su manji od tekuceg elementa niza a.
   Primetimo da nema inicijalizacije j=0.
   Ovo je zato sto jednom preskoceni elementi
   niza b vise nisu u igri ni za bilo koji
   naredni element niza a, jer su svi oni
   veci od tekuceg elementa niza a. */
      for (; j < n_b && b[j] < a[i]; j++);

/* Ako nismo preskocili sve elemente i element
   niza b na kome smo stali je jednak tekucem
   elementu niza a, tada je tekuci element niza
   a u preseku, i treba ga dodati */
      if (j < n_b && a[i] == b[j])
        {
          c[k] = a[i];
          k++;
          j++;
        }
/* Ako smo dosli do kraja niza b, tada ni 
   tekuci ni bilo koji sledeci element niza a
   ne moze biti u preseku, jer su svi oni veci
   od svih elemenata niza b */
      else if (j == n_b)
        break;

    }
/* Vracamo broj elemenata preseka */
  return k;
}


/* Funkcija kreira razliku dva rastuca niza a i b i rezultat smesta u 
   niz c (takodje u rastucem radosledu). Funkcija vraca broj elemenata 
   razlike */
int kreiraj_razliku (int a[], int n_a, int b[], int n_b, int c[])
{
    int i = 0, j = 0 , k = 0;

    /* Sve dok ima elemenata u oba niza...*/
    while(i < n_a && j < n_b)
    {
        /* Ako je tekuci element niza a manji, tada 
           je on u razlici, jer su svi sledeci elementi
           niza b jos veci. Ubacujemo ga u razliku i
           prelazimo na sledeci element niza a */
        if(a[i] < b[j])
            c[k++] = a[i++];
        /* Ako je tekuci element niza b manji, tada
           prelazimo na sledeci element u nizu b */
        else if (a[i] > b[j])
            j++;
        /* Ako su jednaki, tada ih oba preskacemo. Tekuci
           element niza a ocigledno nije u razlici. */
        else
         {
            i++;
            j++;
         }
    }

    /* Ako su preostali elementi niza a, tada su oni u razlici
       jer su svi elementi niza b bili manji od tekuceg elementa
       niza a, i svih koji za njim slede */
    while (i < n_a)
      c[k++] = a[i++];

    /* Vracamo broj elemenata u razlici */
    return k;
}

/* NAPOMENA: Sledi alternativna verzija funkcije za racunanje razlike */ 


/* Funkcija kreira razliku dva rastuca niza a i b i rezultat smesta u 
   niz c (takodje u rastucem radosledu). Funkcija vraca broj elemenata 
   razlike */
int kreiraj_razliku_2 (int a[], int n_a, int b[], int n_b, int c[])
{

  int i, j = 0, k = 0;

/* za svaki element niza A ... */
  for (i = 0; i < n_a; i++)
    {

/* Preskacemo sve elemente niza b koji
   su manji od tekuceg elementa niza a.
   Primetimo da nema inicijalizacije j=0.
   Ovo je zato sto jednom preskoceni elementi
   niza B vise nisu u igri ni za bilo koji
   naredni element niza a, jer su svi oni
   veci od tekuceg elementa niza a. */
      for (; j < n_b && b[j] < a[i]; j++);

/* Ako smo preskocili sve elemente ili smo 
   stali kod elementa koji je veci od tekuceg 
   elementa niza a, znaci da u nizu b ne postoji
   element jednak tekucem elementu niza a, tj.
   tekuci element niza a je u razlici a\b. 
*/
      if (j == n_b || a[i] < b[j])
        {
          c[k] = a[i];
          k++;
        }


    }

/* Vracamo broj elemenata razlike */
  return k;
}
