#include <stdio.h>

/* Program broji reci u tekstu */

#define VAN_RECI 0 
#define U_RECI 1

/* NAPOMENA: Pretprocesorska direktiva #define definise simbolicku konstantu.
   Najpre se navodi identifikator, a zatim (nakon razmaka) niska zamene, tj.
   niz karaktera kojim treba doslovno zameniti svaku pojavu datog
   identifikatora u kodu. Prilikom primene direktive #define, pretprocesor
   ne vrsi proveru sintaksne ispravnosti niske zamene, vec samo doslovno 
   zamenjuje identifikator odgovarajucom niskom. U nasem slucaju ce se svaka
   pojava identifikatora VAN_RECI u fazi pretprocesiranja zameniti karakterom
   0, a svaka pojava U_RECI ce se zameniti karakterom 1, nakon cega ce se
   zapoceti sam proces prevodjenja.

   Simbolicke konstante su korisne u slucajevima kada postoji konstanta kojoj
   treba dodeliti neko ime koje opisuje njen smisao. Time se povecava
   citljivost programa, a i olaksava se njegovo odrzavanje -- ako zelimo da
   promenimo vrednost konstante, dovoljno je da to uradimo samo u direktivi
   #define -- ona ce to dosledno zameniti svuda u programu gde se taj
   identifikator pojavljuje. 

   Konvencija je da se identifikatori u #define direktivi pisu velikim
   slovima, iako sam jezik ne zahteva da bude tako.
*/

int main()
{
  int c;
  int stanje = 0;
  int br = 0;

  /* Brojanje reci u tekstu: prilikom prolaska kroz tekst mozemo se nalaziti
     u jednom od dva stanja: U_RECI i VAN_RECI. Kada se nalazimo u stanju
     VAN_RECI, tada treba preskakati beline, a kada se naidje na prvi 
     karakter koji nije belina, tada pocinje nova rec -- prelazimo u stanje
     u_RECI i uvecavamo brojac. Kada se nalazimo u stanju U_RECI, tada 
     preskacemo sve karaktere koji nisu belina (jer su oni deo te iste reci),
     a kada naidjemo na prvu belinu, prelazimo u stanje VAN_RECI (jer je tu
     zavrsena tekuca rec). Opisan algoritam je prilicno lako iskodirati
     pomocu switch() naredbe, pri cemu cemo najpre razlikovati slucajeve
     po stanju (spoljasni switch()), a zatim po tekucem karakteru (unutrasnji
     switch-evi). */
  while((c = getchar()) != EOF)
    {
      switch(stanje)
	{
	  /* Ako smo u stanju van reci... */
	case VAN_RECI:
	  switch(c)
	    {
	      /* U slucaju belina, ne radimo nista (u sva tri slucajeva
		 se izvrsava samo naredba break) */
	    case ' ':
	    case '\t':
	    case '\n':
	      break;

	      /* U svim ostalim slucajevima, zapocinjemo rec */ 
	    default:
	      br++;
	      stanje = U_RECI;
	      break;
	    }
	  break;
	  
	  /* Ako smo u stanju U_RECI... */ 
	case U_RECI:
	  switch(c)
	    {
	      /* Ako je belina, tada prelazimo u stanje VAN_RECI */
	    case ' ':
	    case '\t':
	    case '\n':
	      stanje = VAN_RECI;
	      break;

	      /* U suprotnom, ako nije belina, ne radimo nista, jer smo
		 jos uvek u reci (nema default labele) */
	    }
	  break;
	}


    }

  printf("Broj reci: %d\n", br);

  return 0;
}
