#include <stdio.h>

/* Program ispisuje na izlaz prvih m prostih brojeva */

int main()
{
  int n, k, m, i;

  scanf("%d", &m);

  /* Polazeci od n = 2, za sve brojeve redom proveravamo da li
     su prosti. Kada pronadjemo prost broj, tada ga ispisujemo
     i uvecavamo brojac prostih brojeva (promenljiva i) za jedan.
     Kada i postane m, tada smo vec pronasli i ispisali m prostih
     brojeva (kako je korisnik trazio), pa zavrsavamo petlju. */
  for(i = 0, n = 2; i < m; n++)
    {
      /* NAPOMENA:
	 Operator zarez (,) je binarni operator koji se izracunava
	 na sledeci nacin. Izraz: 
	 
	 E1, E2
	 
	 je istog tipa kao i E2, a vrednost izraza ce biti upravo 
	 izracunata vrednost izraza E2. Izraz se izracunava tako sto
	 se najpre izracuna izraz E1, a zatim izraz E2. Dakle, vrednost
	 izraza E1 se izracunava pre izracunavanja izraza E2, a sama
	 vrednost E1 se ignorise -- njen jedini smisao je u bocnim 
	 efektima koji to izracunavanje proizvodi. Operator zarez je
	 levo asocijativan, tako da izraz:

	 E1,E2,E3,...,En

	 je isto sto i:
	 
	 (...(E1,E2),E3),...),En)
	 
	 sto za efekat ima da se izrazi racunaju redom sa leva u desno. Tip
	 i vrednost se uzimaju iz poslednjog izraza En. Smisao ovog operatora
	 je da se omoguci da se vise izraza sintaksno tumace kao jedan (slicno
	 kao sto blok naredba ima ulogu da se vise naredbi sintaksno tumace
	 kao jedna naredba). Ovo je potrebno tamo gde C ocekuje jedan izraz,
	 a mi zelimo da izracunamo vise izraza -- ovo je tipicno za for
	 petlju, za njen izraz inicijalizacije i/ili izraz inkrementacije.
	 U nasem primeru, mi inicijalizujemo dve varijable, izrazom 
	 
	 i = 0, n = 2

	 cime postizemo dva bocna efekta u jednom izrazu.
      */

      /* Ako je broj paran, a nije 2, tada nema potrebe da ispitujemo da li
	 je prost -- definitivno nije! */
      if(n % 2 == 0 && n != 2)
	continue;

      /* NAPOMENA: Naredba continue prekida samo tekucu iteraciju petlje, ali 
	 ne prekida petlju, vec prelazi na sledecu iteraciju petlje. U slucaju
	 for petlje, ovo znaci da se prelazi na izracunavanje izraza 
	 inkrementacije, a zatim na ispitivanje uslova. U slucaju while i 
	 do-while petlji ovo znaci da se prelazi odmah na ispitivanje 
	 uslova. */

      /* Ispitujemo da li je n prost */
      for(k = 2; k*k <= n; k++)
	{
	  if(n % k == 0)
	    break;
	}

      /* Ako je prost, ispisujemo ga i uvecavamo brojac prostih brojeva */
      if(k*k > n)
	{
	  printf("%d ", n);
	  i++;
	}
    }

  return 0;
}
