#include <stdio.h>

/* TIPOVI: 
   1) signed char -- oznaceni ceo broj, najcesce jednobajtni (standard
   zahteva da bude "dovoljno veliki da cuva sve vrednosti karakterskog
   skupa na tom racunaru, a to je najcesce ASCII, za sta je dovoljno 1 bajt).
   Vrednosti su u tom slucaju od -128 do +127, a zapisan je u potpunom 
   komplementu.
   2) unsigned char -- neoznacena varijanta, od 0 do 255.
   3) char -- isti kao jedan od gornja dva, zavisi od implementacije koji ce
   biti. Najcesce isto kao i signed char. U tom slucaju, standard zahteva
   da se svi karakteri kodiraju nenegativnim vrednostima.
   4) short (short int, signed short, signed short int) -- oznaceni ceo 
   broj, najcesce 2 bajta. Vrednosti -32768 do +32767, zapisan u potpunom
   komplementu.
   5) unsigned short (unsigned short int) -- neoznacena varijanta prethodnog
   tipa, vrednosti 0 do 65535. 
   6) int (signed int) -- oznaceni ceo broj, najcesce 4 bajta. U tom slucaju
   uzima vrednosti -2147483648 do +2147483647. Zapisan je u potpunom 
   komplementu. 
   7) unsigned (unsigned int) -- neoznacena varijanta prethodnog tipa, sa
   vrednostima u opsegu od 0 do +4294967295
   8) long (long int, signed long, signed long int) -- oznaceni ceo broj,
   najcesce 4 (na 32-bitnim racunarima) ili 8 bajtova (na 64-bitnim), zapisan
   u potpunom komplementu. 
   9) unsigned long (unsigned long int) -- neoznacena varijanta prethodnog
   tipa.
   10) float -- realni broj jednostruke tacnosti. Najcesce 32-bita, u skladu
   sa IEEE-754 standardom. 
   11) double -- realni broj dvostruke tacnosti. Najcesce 64-bita, u skladu sa
   IEEE-754 standardom.
   12) long double -- realni broj dvostruke prosirene tacnosti. Najcesca 
   velicina je 12 bajtova.
   
   Inace, tipovi u C-u su zavisni od platforme, i nisu fiksirani standardom,
   tako da je vecina gornjih napomena samo najcesci slucaj. Ipak, standard
   jezika zahteva da je velicina celobrojnih tipova u sledecem odnosu:
   
   char <= short <= int <= long
   
   kao i da su odgovarajuci naoznaceni tipovi iste velicine kao i oznaceni.
   Slicno, standard zahteva da velicine realnih tipova budu u sledecem odnosu:

   float <= double <= long double
  
   KONSTANTE:
   -- karakterske konstante su tipa int. Zapisuju se izmedju jednostrukih
   navodnika (npr 'a', 'Z', '3', '%'). Njihova vrednost je upravo ASCII
   kod odgovarajuceg karaktera (npr 'A' ima vrednost 65). Osim stampajucih
   ASCII karaktera mogu se navesti i kontrolni karakteri tako sto se navede
   odgovarajuca sekvenca: '\n' (novi red), '\t' tabulator, '\v' vertikalni
   tabulator, '\\' obrnuta kosa crta, '\'' -- apostrof, '\"' -- navodnik, 
   i sl. 
   -- celobrojne konstante su podrazumevano tipa int. Dodatkom sufiksa 
   l ili L dobija se konstanta tipa long (npr 34L, 17l), dok se dodatkom
   sufiksa u ili U dobija konstant tipa unsigned (npr 12u,
   456U). Kombinacija ova dva sufiksa daje tip unsigned long (npr. 12ul, 
   54Lu, 124UL). 
   -- celobrojne konstante se mogu zadati i u oktalnom i u heksadekadnom
   formatu. Oktalni zapis pocinje karakterom 0 nakon cega slede oktalne
   cifre (npr 054, 012, 0777). Heksadekadne konstante pocinju sa 0x (ili 0X)
   nakon cega slede heksadekadne cifre (npr 0x54fa, 0X42Fa3, 0xFFeF). 
   -- realne konstante su podrazumevano tipa double. Dodatkom sufiksa
   l ili L dobija se konstanta tipa long double (npr 4.2L, .5e-2l). Dodatkom
   sufiksa f (ili F) dobija se konstanta tipa float (npr 4.2f, 0.2e5F).
   
   scanf/printf specifikatori:
   TIP               SCANF            PRINTF 
   -- char               %c               %c
   -- short              %hd, %hi         %hd, %hi
   -- unsigned short     %hu, %ho, %hx    %hu, %ho, %hx, %hX,
   -- int                %d, %i           %d, %i
   -- unsigned           %u, %o, %x       %u, %o, %x, %X
   -- long               %ld, %li         %ld, %li
   -- unsigned long      %lu, %lo, %lx    %lu, %lo, %lx, %lX
   -- float              %f               %f,  %g, %e
   -- double             %lf              %f,  %g, %e
   -- long double        %Lf              %Lf
   
   Za detalje pogledati odgovarajuce poglavlje u knjizi K&R.
*/


int main()
{
  /* NAPOMENA: S obzirom na to da velicine tipova u C-u nisi fiksirane 
     standardom, vec su zavisne od platforme, ponekad je neophodno da 
     programer moze da utvrdi koja je velicina nekog tipa na konkretnom
     racunaru. U tu svrhu postoji ugradjeni C operator sizeof() koji kao
     rezultat vraca broj bajtova koje podatak tog tipa zauzima u memoriji.
     Ovaj operator moze kao argument imati bilo ime tipa, bilo podatak ili
     izraz (u kom slucaju se u fazi prevodjenja utvrdjuje tip podatka odnosno
     izraza i vraca se velicina rezultujuceg tipa u bajtovima). sizeof() se
     moze primeniti kako na proste, tako i na slozene tipove (koje cemo uciti
     kasnije). U ovom primeru prikazujemo velicine osnovnih tipova u 
     bajtovima (rezultat na Vasem racunaru moze biti drugaciji) */

  printf("Velicina tipa char u bajtovima je %d\n", sizeof(char));
  printf("Velicina tipa short u bajtovima je %d\n", sizeof(short));
  printf("Velicina tipa int u bajtovima je %d\n", sizeof(int));
  printf("Velicina tipa long u bajtovima je %d\n", sizeof(long));
  printf("Velicina tipa float u bajtovima je %d\n", sizeof(float));
  printf("Velicina tipa double u bajtovima je %d\n", sizeof(double));
  printf("Velicina tipa long double u bajtovima je %d\n", sizeof(long double));

  return 0;
}
