#include <stdio.h>

/* Program ispisuje dekadne cifre datog broja u obrnutom poretku */
int main()
{
  int x;

  /* Ucitavamo ceo broj u dekadnom formatu */
  scanf("%d", &x);

  /* Implementacija pomocu while petlje. Primetimo da moramo da imamo
     jednu pred-iteraciju, kako bismo i u slucaju x == 0 ispisali 
     bar jednu cifru. 

  printf("%d", x % 10);
  x /= 10;

  while(x != 0)
    {
      printf("%d", x % 10);
      x /= 10;
    }
  */


  /* PETLJA SA POSTUSLOVOM je petlja u kojoj se uslov proverava nakon 
     izvrsene iteracije. Ovim se postize da se prva iteracija uvek 
     izvrsava, tj. petlja ima bar jednu iteraciju u svakom slucaju.
     U gornjem primeru smo imali upravo potrebu za takvom petljom.
     U C-u, sintaksa za petlju sa post-uslovom je:

  do 
    naredba
   while(uslov);

   Naredba moze biti prosta ili slozena (najcesce se koristi blok naredba,
   iako ne mora). Petlja se izvrsava na sledeci nacin: najpre se izvrsi 
   naredba, pa se zatim proveri uslov. Ako je uslov ispunjen, ponovo se 
   izvrsava naredba, pa se ponovo proverava uslov, i tako redom. Prvi put
   kada uslov nije ispunjen, izlazi se iz petlje. Opisana semantika je 
   ekvivalentna sledecoj implementaciji pomocu while petlje:

  naredba
  while(uslov)
   naredba

   pri cemu je na oba mesta ista naredba. Slicno, svaka while petlja se
   moze implementirati pomocu do-while petlje, tj. petlja:

   while(uslov)
     naredba

   je ekvivalentna sa:

   if(uslov)
    do
     naredba
    while(uslov);

   pri cemu su oba uslova ista. Naravno, iako smo ovim pokazali da su ove
   dve petlje ekvivalente po izrazajnosti, to svakako ne znaci da treba
   izrazavati ih jednu preko druge -- naprotiv, postoje algoritmi gde je
   prirodnije imati postuslov (kao u nasem primeru) i tada treba koristiti
   do-while petlju, dok postoje algoritmi gde je prirodnije imati preduslov
   (tj. dozvoliti da se petlja ne izvrsi ni jednom, ako uslov u startu nije
   ispunjen), kada treba koristiti while petlju.
  */

  do {
    printf("%d", x % 10);
    x /= 10;
  } while(x != 0);

  printf("\n");


  return 0;
}
