#include <stdio.h>
#include <math.h>

/* NAPOMENE:
     Zaglavlje math.h:

     Ovo zaglavlje sadrzi razne matematicke funkcije koje sam jezik ne
     podrzava, a cesto su potrebne:
     -- fabs(x) izracunava apsolutnu vrednost realnog broja
     -- sin(x), cos(x), tan(x)... trigonometrijske funkcije
     -- asin(x), acos(x), atan(x), ... inverzne trigonometrijske funkcije
     -- sqrt(x) -- kvadratni koren
     -- pow(x,y)  -- racuna x na y.
     -- floor(x) -- najveci ceo broj koji nije veci od argumenta
     -- ceil(x) -- najmanji ceo broj koji nije manji od argumenta
     -- log(x) -- prirodni logaritam
     -- log10(x) -- dekadni logaritam, i sl.

     Blok naredba:
 
     {
       naredba1
       naredba2
       ...
       naredban     
     }
     

     je slozena naredba koja se sastoji iz viticastih zagrada u kojima se 
     nalazi niz naredbi (prostih ili slozenih). Naredba se izvrsava tako
     sto se redom izvrse sve naredbe iz kojih je blok naredba sacinjena.
     Osnovna osobina blok naredbe je da se ona sintaksno tumaci kao JEDNA
     naredba. Ovo omogucava da se na mestima gde se sintaksno ocekuje jedna
     naredba nalazi vise naredbi koje se redom izvrsavaju 
     (npr u if-u ili else-u), Tako na primer:

     if(uslov)
     {
       naredba1
       naredba2
     }

     izvrsava obe naredbe ako je uslov ispunjen, a nijednu ako uslov nije
     ispunjen. Ovo je zato sto je naredba u okviru if-a u stvari blok naredba
     koju sacinjavaju dve naredbe, koje se izvrsavaju redom u kome su
     navedene. Sa druge strane:

     if(uslov)
       naredba1
       naredba2

     izvrsava prvu naredbu ako je uslov ispunjen, a ne izvrsava je u
     suprotnom. Druga naredba se izvrsava UVEK, jer ona nije u okviru if-a.
     Naredba u okviru if-a je uvek samo JEDNA naredba, a to je u ovom slucaju
     naredba1. Ako zelite vise naredbi u okviru if-a (ili na drugim mestima
     gde se ocekuje jedna naredba, npr. else, petlje, i sl.) morate da 
     sintaksno "simulirate" jednu naredbu koriscenjem blok naredbi. 

     Blok naredba moze da sadrzi i jednu naredbu. U tom slucaju, viticaste
     zagrade se mogu izostaviti (jer je to i inace jedna naredba). Blok
     naredba moze sadrzati i nula naredbi -- u tom slucaju je to prazna
     blok naredba {} koja ne radi nista.

     Visestruko grananje:

     if(uslov1)
       naredba1
     else if(uslov2)
       naredba2
     else if(uslov3)
       naredba3
       ...
     else if(uslovn)
       naredban
     else
       podrazumevana_naredba

     Svaka od naredbi moze biti prosta (izraz;) ili slozena (blok, if, petlja,
     i sl.). S obzirom da je naredba u okviru prvog else-a zapravo samo JEDNA
     if naredba (ma kako slozeno izgledala), nisu potrebne viticaste zagrade.

     Naredba se izvrsava tako sto se redom ispituju uslovi -- za prvi uslov koji
     bude ispunjen izvrsava se odgovarajuca naredba i nakon toga se nastavlja
     dalje (preostali uslovi se ne ispituju i njihove naredbe se svakako ne
     izvrsavaju). 

     Poslednji else ne mora da postoji -- u tom slucaju nece biti
     podrazumevane naredbe i ukoliko ni jedan od uslova nije ispunjen nece se
     izvrsiti ni jedna od naredbi.
     
     Dakle, u visestrukom grananju uvek se izvrsava tacno jedna od naredbi
     (odnosno, najvise jedna u slucaju da nema poslednjeg else-a).
*/




/* Program izracunava realna resenja kvadratne jednacine ax^2 + bx + c = 0 */
int main()
{
  float a, b, c, x1, x2, D;
  float eps = 0.00001;

  /* Ucitavamo tri realna broja: a, b, c (scanf specifikator %f za tip float) */
  scanf("%f %f %f", &a, &b, &c);
  
  /* Izracunavamo diskriminantu */
  D = b*b - 4*a*c;

  if(D > 0)
    {
      x1 = (-b + sqrt(D)) / (2 * a);
      x2 = (-b - sqrt(D)) / (2 * a);
      printf("Jednacina ima dva realna resenja: %f %f\n", x1, x2);
    }
  else if(fabs(D) < eps)  /* else if(D == 0) */
    {
      x1 = -b / (2 * a);
      printf("Jednacina ima jedno resenje: %f\n", x1);
    }
  else
    printf("Jendacina nema realnih resenja\n");
    
  /* NAPOMENA: poredjenje realnih brojeva na jednakost najcesce nije dobra
     ideja, zbog nepreciznosti koje se unose prilikom racunskih operacija.
     Zato se moze dogoditi da dva broja ne budu jednaka iako bi, po logici
     stvari, trebalo da budu. Zbog toga se obicno umesto a == b koristi
     fabs(a - b) < eps, gde je eps neka mala pozitivna vrednost
     (npr. 0.000001). 
  */

  return 0;
}
