/*  BITNI POJMOVI:
    -- podatak: svaki podatak ima tip i vrednost. C je "tipiziran jezik", 
    sto znaci da svaki podatak ima jedinstven i fiksirani tip koji se ne
    menja tokom zivotnog veka tog podatka.
    -- tip podatka: odredjuje skup mogucih vrednosti, velicinu u memoriji, 
    nacin predstavljanja (binarnog kodiranja) podatka. Svaki podatak u
    svakom trenutku ima neku vrednost iz skupa vrednosti pridruzenog tipa.
    -- konstante: podaci cija je vrednost fiksirana i odredjena njihovim
    literalnim zapisom. Npr., 2, 4.5, 'a',  "milan". Zapis konstante takodje
    jednoznacno odredjuje i tip konstante (o pravilima za odredjivanje tipa
    konstante ce kasnije biti vise reci).
    -- promenljive: podatak cija se vrednost moze menjati tokom zivotnog
    veka tog podatka. Svaka promenljiva ima (pored tipa i vrednosti) svoju
    adresu u memoriji, kao i ime (identifikator) pomocu koga joj pristupamo
    u programu. Sve promenljive se u C-u moraju DEFINISATI, kako bi se
    za njih rezervisao prostor u memoriji dovoljan za cuvanje podatka tog
    tipa. 
    -- dodela vrednosti: upisivanje vrednosti u memorijski prostor koji je
    rezervisan za neku promenljivu. Dodelom se toj promenljivoj menja
    vrednost. Izvrsavanje programa se sastoji iz niza koraka kojima se
    promenljivama u memoriji menjaju vrednosti (mehanizmom dodele vrednosti).
    Bez mehanizma dodele, sve promenljive bi imale istu vrednost tokom celog
    svog zivota, pa samim tim ne bi vrsile svoju ulogu (bile bi isto sto i
    konstante). Svrha promenljivih je upravo u tome da u toku rada programa
    mogu da prihvate izracunate vrednosti (medjurezultate) i da ih sacuvaju
    kako bi se iskoristile u nekom od sledecih koraka.
    -- operator: element jezika koja oznacava neku operaciju. Programski jezik
    C ima bogat skup operatora. Neki primeri: +, -, *, /, %, <, >, <=, ||,
    itd.
    -- izraz: dobija se kombinovanjem promenljivih i konstanti pomocu
    operatora. Moze biti proizvoljne slozenosti. Primeri: a + b, 
    x - 1,  u < v,  (a * b + c) / 2, a % 2 + 1, itd. Svaki izraz ima tip
    i vrednost. Tip izraza zavisi samo od tipova konstanti i promenljivih
    koje u njemu ucestvuju, kao i operatora koji ih povezuju, pa je samim
    tip tip svakog izraza jedinstven i poznat vec u vreme pisanja i 
    prevodjenja programa. Detaljna pravila o odredjivanju tipa izraza 
    prikazacemo kasnije. Sa druge strane, vrednost izraza se izracunava u fazi
    izvrsavanja programa i zavisi od trenutnih vrednosti promenljivih koje
    ucestvuju u izrazu (a one mogu zavisiti od ulaza programa).
    -- bocni efekat: mehanizam programskog jezika C kojim se prilikom 
    izracunavanja nekog izraza desava dodela vrednosti nekoj od promenljivih.
    Bocni efekat je zapravo nacin na koji C implementira dodelu. Da bi izraz
    imao bocni efekat, potrebno je da u njemu postoji operator koji ima bocni
    efekat. Najprostoji ovakav operator je OPERATOR DODELE (=). Npr. x = a + 1
    Efekat ovakvog izraza dodele je da se prilikom izracunavanja ovog izraza
    vrednost izraza na desnoj strani operatora dodele (izraz a + 1) dodeljuje
    promenljivoj na levoj strani operatora dodele (promenljivoj x). Pored ovog
    operatora postoje jos neki operatori koji imaju bocni efekat, ali sa njima
    cemo se upoznati kasnije.
    -- naredba:  izvrsni segment programa. Naredba predstavlja ekvivalent
    algoritamskog koraka koji treba izvrsiti. Svaka naredba bi trebalo da
    ima nekakav efekat, tj. da nekim promenljivama promeni vrednosti.
    Najprostija naredba je tzv. "prosta naredba". Njen oblik je:
    
      izraz;

    Dakle, svaka prosta naredba se mora zavrsiti znakom ; Izraz koji cini 
    prostu naredbu moze biti bilo koji izraz:
      a + b;
      x = a + b;
      x = x - 1;
    
    Prosta naredba se izvrsava tako sto se prosto izracuna izraz koji je cini.
    Vrednost izracunatog izraza se u potpunosti ignorise -- sustina je u 
    bocnim efektima koji se desi u toku njegovog izracunavanja. Tako na
    primer, prva naredba u gornjim primerima (a+b;) ne radi nista, zato 
    sto izraz a+b nema nikakav bocni efekat (izracunati zbir se ignorise i
    nigde se ne upisuje). Sa druge strane, naredba x = a + b; u promenljivu
    x upisuje zbir a + b (zato sto se prilikom izracunavanja izraza
    x = a + b desava bocni efekat -- dodeljuje se vrednost izraza na desnoj
    strani promenljivoj na levoj strani). Iako programski jezik C ne zahteva
    da naredba ima bocni efekat, jasno je da jedino takve naredbe imaju 
    smisla. 
    -- potprogram: deo programa koji resava jedan deo problema. Mehanizmom
    potprograma se problem dekomponuje u prostije celine koje se zasebno
    resavaju, a zatim povezuju u jednu celinu. Ovo olaksava programiranje
    povecava citljivost i omogucava lakse ponovno koriscenje postojeceg koda. 
    U C-u se potprogrami zovu FUNKCIJE. Sa funkcijama cemo se upoznati kasnije
    u toku kursa.
*/

#include <stdio.h>

/* NAPOMENA: Prevodjenje C programa ima jednu dodatnu pred-fazu u odnosu na 
   vecinu ostalih programskih jezika -- to je faza PRETPROCESIRANJA.
   Pretprocesiranjem se obradjuju tzv. DIREKTIVE PRETPROCESORA, kojima se
   tekst sa C kodom transformise na izvestan nacin pre nego sto se prosledi
   prevodiocu. Postoji vise razlicitih direktiva koje na razlicite nacine
   uticu na C kod. Direktive pretprocesora pocinju simbolom #, uvek se nalaze
   na pocetku linije i prostiru se do kraja linije. Jedna od najznacajnihih 
   je direktiva #include. Njen efekat je da se prilikom pretprocesiranja
   direktiva zamenjuje sadrzajem fajla koji se navodi kao argument direktive.
   U gornjem slucaju, kompletan sadrzaj fajla stdio.h ce biti ukljucen u C
   kod pre poziva prevodiocu.

   NAPOMENA: Svaki C prevodilac se isporucuje zajedno sa bibliotekom funkcija
   koja se zove Standardna C Biblioteka. Ova biblioteka sadrzi veliki broj
   korisnih funkcija koje sam jezik C u uzem smislu ne podrzava (matematicke
   funkcije, funkcije za rad sa stringovima, i sl.). Odgovarajuci skup 
   funkcija se ukljucuje u program tako sto se direktivom #include ukljuci
   odgovarajuce zaglavlje koje sadrzi deklaracije tih funkcija. Zaglavlja 
   imaju ekstenziju .h (za razliku od fajlova sa C kodom koji imaju ekstenziju
   .c).  Jedno takvo zaglavlje standardne biblioteke je i stdio.h koje 
   ukljucuje funkcije za rad sa ulazom i izlazom. Naime, programski jezik
   C ne sadrzi nikakve ugradjene mehanizme ulaza i izlaza, kao sto je to
   slucaj sa vecinom drugih programskih jezika (readln/writeln u pascal-u).
   Umesto toga, C programi se oslanjaju na ulazno izlazne mehanizme samog
   operativnog sistema na kome se sve izvrsava (UNIX, Windows...). S obzirom
   da ovi mehanizmi nisu isti od sistema do sistema, standardna biblioteka
   sadrzi skup funkcija kojima se koriscenje ulaza i izlaza unifikuje --
   ove standardne funkcije se uvek isto koriste i rade, iako se interno
   implementiraju drugacije na razlicitim sistemima. Ove funkcije se nalaze u
   zaglavlju stdio.h, pa se zato ovo zaglavlje mora ukljuciti ako planiramo
   da koristimo ulaz i izlaz (sto je gotovo uvek slucaj).

   NAPOMENA: C program se sastoji iz definicija funkcija. Postoji jedna
   funkcija koja uvek mora da postoji u svakom C programu -- to je main()
   funkcija. Ova funkcija predstavlja ulaznu tacku programa -- program 
   zapocinje izvrsavanje pokretanjem main() funkcije i zavrsava svoj rad
   kada se main() funkcija zavrsi. Ostale funkcije su opcione, i mogu se
   pozivati iz main() funkcije i/ili drugih funkcija. U ovim prvim primerima
   mi cemo raditi iskljucivo sa main() funkcijom, dok cemo kasnije u toku
   kursa nauciti kako da pisemo i druge funkcije.

   NAPOMENA: Programski jezik C razlikuje velika i mala slova 
   ("case-sensitive"). To znaci da je promenljiva a razlicita od promenljive
   A, kao i da je funkcija Main() razlicita od funkcije main(). Po ovome se
   C razlikuje od jezika kao sto je Pascal (koji ne razlikuje mala i velika
   slova). 
 */


int main () /* Zaglavlje funkcije -- bice objasnjeno kasnije */
{           /* Telo funkcije se nalazi izmedju znakova { i  } */

  /* NAPOMENA: Sve promenljive se moraju DEKLARISATI pre koriscenja. Time
     se uvodi ime promenljive i prevodiocu se saopstava kog su te promenljive
     tipa, cime ce prevodilac biti u mogucnosti da proveri ispravnost 
     koriscenja promenljivih u programu, kao i da odgovarajuce operacije nad
     podacima izvrsi na nacin koji odgovara tom tipu. Deklaracije u C-u su
     ujedno i DEFINICIJE, tj. njima se za promenljivu kreira prostor u
     memoriji u kom se cuva njihova vrednost. Deklaracija se sastoji iz 
     imena tipa nakon cega slede zarezima razdvojena imena promenljivih
     tog tipa koje se deklarisu. Svaka promenljiva moze imati i inicijalnu
     vrednosti. Ako se inicijalna vrednost ne navede, tada promenljiva
     ima nedefinisanu vrednost (tj. vrednost ce biti ona koja se zatekne
     u memoriji na tom mestu u vreme izvrsavanja). Promenljive istog tipa
     se mogu deklarisati zajedno u jednoj deklaraciji, a mogu se odvojiti
     i u posebne deklaracije, sto je stvar ukusa. Svaka deklaracija se
     zavrsava znakom ; */
  int x = 0, y;
  int s;

  /* NAPOMENA: Tip int pretstavlja oznaceni ceo broj u potpunom komplementu.
     Najcesce je 32-bitni (4 bajta) mada standard C-a ne fiksira velicinu
     i nacin predstavljanja tipova -- to zavisi od konkretne arhitekture
     na kojoj se program prevodi i izvrsava */
  
  /* NAPOMENA: Funkcija scanf() je funkcija deklarisana u stdio.h koja se
     koristi za formatirani ulaz. Prvi argument je tzv. "format string".
     U pitanju je niska karaktera koja opisuje sta treba ucitati (niske
     se u C-u pisu izmedju dvostrukih navodnika). Format string sadrzi
     specifikatore konverzije -- specifikator %d znaci da se na tom mestu
     ocekuje oznaceni dekadno zapisani ceo broj. Ovo znaci da ce sledeci 
     poziv scanf()-a ucitavati dva dekadna cela broja razdvojena razmakom. 
     Ostali argumenti scanf()-a su ADRESE promenljivih u koje treba upisati 
     ucitane vrednosti. Adresa podatka se u C-u dobija pomocu operatora 
     & (ampersend). &x se cita kao "adresa od x". Rad sa adresama ce
     detaljnije biti opisan kasnije u toku kursa. */
  scanf("%d %d", &x, &y);

  s = x + y;  /* Naredba dodeljuje promenljivoj s zbir promenljivih x i y. */
  
  /* NAPOMENA: Funkcija printf() je funkcija deklarisana u stdio.h koja se
     koristi za formatirani izlaz. Prvi argument je ponovo format string koji
     definise sta treba ispisati. U format string se mogu umetnuti 
     specifikatori konverzije umesto kojih ce se na tom mestu prilikom
     ispisa zameniti odgovarajuce vrednosti. Ostali argumenti su upravo izrazi
     cije se vrednosti zamenjuju umesto specifikatora konverzije, onim redom
     kojim su navedeni. Npr, u donjem primeru ce se
     umesto prvog %d ispisati vrednost od x (kao dekadni oznaceni ceo broj), 
     umesto drugog vrednost od y, a umesto treceg vrednost od s. */
  printf("Zbir brojeva %d i %d je: %d\n", x, y, s);

  /* Ovo ce biti objasnjeno kasnije */
  return 0;
}
 
   
