#include <stdio.h>
#include <string.h>


#define MAX_IME 20
#define MAX_PREZIME 30
#define MAX_SMER 10

#define MAX_STUDENATA 100

/* Struktura koja predstavlja informacije o studentu. U ovom primeru
 demonstriramo dve bitne stvari:
 1) Clanovi strukture mogu biti i nizovi (kao i strukture, kao i
 pokazivaci...)
 2) Strukturnim tipovima se mogu predstavljati razni slozeni objekti i pojmovi
 iz stvarnog zivota (npr. studenti, zaposleni, automobili,...) 
*/
typedef struct student {

  char ime[MAX_IME];
  char prezime[MAX_PREZIME];
  char smer[MAX_SMER];
  double prosek;
} Student;


/* Funkcija ucitava podatke o studentu */
void ucitaj(Student *s)
{
  /* Staticka promenljiva -- inicijalizovana nulum */
  static int broj;
  
  printf("Unos podataka o studentu br. %d\n", ++broj);
  printf("Prezime: ");
  scanf("%s", s->prezime);
  printf("Ime: ");
  scanf("%s", s->ime);
  printf("Smer: ");
  scanf("%s", s->smer);
  printf("Prosek: ");
  scanf("%lf", &s->prosek);

}

/* Funkcija pronalazi studenta sa najvecim prosekom i vraca indeks
   odgovarajuceg elementa u nizu struktura. Ovde vidimo da 
   strukturni objekti mogu biti elementi nizova. */
int najveci_prosek(Student * studenti, int n)
{
  int i;
  int maxi = 0; /* Inicijalno pretpostavimo da je prvi najveci */

  /* Uporedjujemo prosek svakog studenta sa do sada najvecim prosekom i ako
     je veci azuriramo indeks maxi */
  for(i = 1; i < n; i++)
    if(studenti[i].prosek > studenti[maxi].prosek)
      maxi = i;
  
  /* Vracamo indeks studenta sa najvecim prosekom */
  return maxi;
}

/* Ispisujemo informacije o studentu */
void ispisi(Student *s)
{
  printf("Prezime: %s\nIme: %s\nSmer: %s\nProsek: %f\n", 
	 s->prezime, s->ime, s->smer, s->prosek);  
}

/* Funkcija main */
int main ()
{

  int n, i;
  
  Student studenti[MAX_STUDENATA]; /* Niz struktura */

  /* Ucitavamo broj studenata */
  printf("Uneti broj studenata: ");
  scanf("%d", &n);

  /* Ucitavamo informacije o studentima */
  for(i = 0; i < n;  i++)
    ucitaj(&studenti[i]);
  
  /* Pronalazimo studenta sa najvecim prosekom */
  i = najveci_prosek(studenti, n);

  /* Ispisujemo studenta sa najvecim prosekom */
  printf("Student sa najvecim prosekom:\n");
  ispisi(&studenti[i]);
  
  return 0;
}
