#include <stdio.h>
#include <math.h>

/* NAPOMENA: Kljucna rec typedef definise novo ime za postojeci 
   tip. Ako kazemo:
   
   typedef int Ceo;

   tada se umesto da se definise promenljiva Ceo tipa int definise novo ime za
   tip int. Sada se moze definisati:

   Ceo a;

   sto je potpuno ekvivalentno sa:
   
   int a;

   Ova kljucna rec se najcesce koristi za izbegavanje stalnog navodjenja imena
   tipova koja umeju da budu dosta glomazna, sto je tipicno za strukture. Npr,
   ako kazemo:

   typedef struct s {
   ....
   } S;

   tada se umesto da se definise promenljiva S tipa "struct s" definise novo
   ime za tip "struct s". Sada umesto da pisemo:

   struct s a;

   mozemo da napisemo:
   
   S a;

   sto je kompaktniji zapis.
*/


/* Struktura tacka koja predstavlja tacku u euklidskoj ravni */
typedef struct tacka {
  double x;
  double y;
} Tacka;

/* Struktura krug sadrzi centar i poluprecnik kruga. Centar kruga je podatak
   tipa struct tacka. Ovim demonstriramo da clan strukture moze biti podatak
   bilo kog tipa, pa i druga struktura */
typedef struct krug {
  Tacka o;
  double r;
} Krug;

/* Funkcija racuna rastojanje izmedju dve tacke. Ova funkcija demonstrira
   prenos struktura preko pokazivaca. Ovaj pristup treba uvek koristiti,
   cak i kada nemamo nameru da menjamo vrednost podatka unutar funkcije,
   zato sto je prenos pokazivaca brzi nego kopiranje citavog objekta 
   strukturnog tipa. 
*/
double rastojanje(Tacka *a, Tacka *b)
{
  /* Obratiti paznju na pristup clanovima strukture preko pokazivaca i 
     operatora strelica. a->x je ekvivalentno sa (*a).x, ali je zapis
     kompaktniji. Razlog uvodjenja ovog operatora je upravo u veoma
     cestom pristupu strukturnim objektima preko pokazivaca. Dakle, 
     operator strelica najpre dereferencira pokazivac na strukturu, a 
     nakon toga u dobijenom strukturnom objektu pristupa clanu sa 
     tim imenom. */
  return sqrt((a->x - b->x) * (a->x - b->x) + (a->y - b->y) * (a->y - b->y));
}

/* Funkcija odredjuje tacku koja je srediste duzi (a,b). Ovog puta se
   strukturni parametri prenose po adresi. Takodje, funkcija ne vraca 
   strukturu, vec postoji i treci "izlazni" parametar -- pokazivac na
   strukturu Tacka u koju treba upisati koordinate sredista. Ovo je 
   svakako najefikasniji nacin koji treba uvek koristiti (osim kada je
   sintaksna pogodnost "vracanja" strukture od nekog posebnog znacaja
   u programu, a strukture nisu preterano velike). */
void srediste (Tacka * a, Tacka * b, Tacka * s)
{
 
  s->x = (a->x + b->x) / 2;
  s->y = (a->y + b->y) / 2;
}


/* Funkcija utvrdjuje da li tacka p pripada krugu k. */
int u_krugu(Tacka *p, Krug *k)
{
  /* Funkcija rastojanje ocekuje adrese dve strukture Tacka. Promenljiva
     p je vec pokazivac, a drugi parametar je adresa strukture k->o. 
     Primetimo da nisu potrebne zagrade oko k->o, zato sto operator
     -> (kao i operator . ) ima najvisi moguci prioritet. */
  if(rastojanje(p, &k->o) <= k->r)
    return 1;
  else
    return 0;
}

/* Funkcija main */
int main ()
{

  Tacka p;
  Krug k;

  /* Ucitavamo koordinate tacaka i poluprecnik kruga */
  
  printf("Uneti koordinate tacke p: ");
  scanf("%lf%lf", &p.x, &p.y);

  printf("Uneti koordinate centra kruga: ");
  scanf("%lf%lf", &k.o.x, &k.o.y);

  printf("Uneti poluprecnik kruga: ");
  scanf("%lf", &k.r);
  
  /* Ispitujemo da li tacka pripada krugu i ispisujemo odgovarajuce
     poruke. Obratiti paznju na nacin pozivanja funkcije */
  if(u_krugu(&p, &k))
    printf("Tacka pripada krugu\n");
  else
    printf("Tacka ne pripada krugu\n");

  return 0;
}
