#include <stdio.h>

/* NAPOMENA:

   1) Pokazivacka armitmetika u C-u.
   Dozvoljene operacije sa pokazivacima:
   p = &x (dobijanje pokazivaca, tj. uzimanje adrese podatka)
   *p     (indirekcija, tj. uzimanje podatka na koji pokazuje)
   p == q (uporedjivanje na jednakost, tacno akko pokazuju na ISTI objekat)
   p != q (negacija prethodnog)

   Ako pokazivaci p i q pokazuju na elemente nekog niza, tada je dozvoljeno
   i sledece:
   p < q (tacno, akko p pokazuje na element u nizu koji prethodi elementu
          na koji pokazuje q)
   p > q
   p <= q
   p >= q (analogno)
   
   p + i (sabiranje sa celim brojem i daje adresu elementa niza koji se nalazi
          i pozicija iza elementa na koji pokazuje p. U slucaju da je vrednost
	  i negativna, tada se dobija pokazivac na toliko pozicija ulevo)
   p - i (analogno)
   q - p (daje (ceo) broj pozicija u nizu za koliko se treba pomeriti u 
          odnosu na p, da bi se doslo do q. Moze biti pozitivna ili negativna
	  vrednost. Vazi ekvivalencija: q - p == i <=> p + i == q)
   p++   (ekvivalentno sa p = p + 1, pomera pokazivac za jedno mesto udesno)
   p--   (ekvivalentno sa p = p - 1, pomera pokazivac za jedno mesto ulevo)
   Prefiksne varijante ++p, --p su takodje dozvoljene, a razlika izmedju
   prefiksnih i sufiksnih varijanti je uobicajena.

   2) Ako je p pokazivac, a i ceo broj, tada je izraz p[i] ekvivalentan sa
   *(p + i). Drugim recima, izraz p[i] se izracunava tako sto se najpre
   pomerimo za i pozicija u nizu u odnosu na poziciju na koju pokazuje p,
   a zatim tako dobijeni pokazivac dereferenciramo, dobivsi odgovarajuci
   element niza.

   3) U programskom jeziku C postoji konverzija:

   T[] --> T*  (konverzija niza u pokazivac)

   koja se primenjuje implicitno. Vrednost rezultujuceg pokazivackog izraza 
   bice adresa pocetnog elementa polaznog niza. Ova konverzija se primenjuje
   automatski na svaki izraz tipa niz koji se pojavi u programu, izuzev u
   dva slucaja:
   
   sizeof(a) vraca velicinu celog niza u bajtovima (dakle, ovde niz ostaje niz)
   
   &a vraca "pokazivac na niz", a ne "pokazivac na pokazivac" (sto ne bi ni
   imalo smisla, jer ne postoji pokazivacka promenljiva kojoj bi uzeli adresu)
   
   Oba ova slucaja nisu za sada od znacaja (bice u drugom semestru). U svim
   ostalim slucajevima se uvek ime niza ponasa kao KONSTANTAN pokazivac 
   na pocetni element niza. Otuda je:

   a[i]  <=> *(a + i)
   
   Upravo zato indeksi nizova u C-u pocinju od nule, jer je:

   a[0] <=> *a (tj. a[0] je upravo element na koji pokazuje a, a to je pocetni
   element). 
*/


/* Program racuna prosek celih brojeva unetih na ulazu */
int main()
{
  int a[100], *p;
  int n, i; 
  int S = 0;

  scanf("%d", &n);

  /* &a[i] <=> &*(a + i) <=> a + i */

  /* Prvi nacin */
  /* for(i = 0; i < n; i++)
     scanf("%d", a + i); */

  /* Drugi nacin (pokazivacka sintaksa) */
  for(p = a; p < a + n; p++)
    scanf("%d", p);
 
  /* Prvi nacin racunanja sume */
  /*for(p = a; p < a + n ; p++)
    S += *p;*/

  /* Drugi nacin racunanja sume */
  p = a;
  while(p < a + n)
    S += *p++;

  /* NAPOMENA:

     Postoje prefiksni (koji se navode pre operanda) i postfiksni 
     (koji se navode posle operanda) unarni operatori. Postfiksni imaju
     visi prioritet, tako da u izrazu:

     *p++

     zagrade implicitno stoje kao u izrazu:

     *(p++)

     sto znaci da se operator ++ odnosi na pokazivac p. Kada bi zagrade
     stajale drugacije:

     (*p)++

     tada bi se ++ odnosio na *p, tj. uvecavao bi se podatak na koji p 
     pokazuje. U izrazu *++p  su oba operanda prefiksna, pa se grupisanje
     vrsi na nacin koji je jedini moguc: *(++p). 

     Suptilna razlika izmedju izraza *(p++) i *(++p) je u trenutku kada se
     vrsi uvecanje pokazivaca: u prvom slucaju se dereferencira stara vrednost
     pokazivaca, a naknadno se uveca pokazivac. U drugom slucaju se najpre
     uveca pokazivac, pa se nova vrednost pokazivaca dereferencira. */
    
 
  /* Racunanje proseka */
  printf("%f\n", (double)S / n);

  return 0;
}
