#include <stdio.h>

/* Program prikazuje dekadne cifre datog celog broja (u pravom
   poretku - s leva u desno) */
int main()
{

  int cifre[10];    /* Niz je duzine 10, jer u int podatku ne mozemo 
		       cuvati broj sa vise od 10 dekadnih cifara */
  int x, i = 0, j;  

  scanf("%d", &x);

  /* Izdvajamo sve cifre, pocev od cifre najmanje tezine, i smestamo ih
     redom u niz, pocev od pozicije 0. Cifra uz 10^k ce se smestiti u 
     cifre[k]. */
  do
    {
      cifre[i++] = x % 10; /* Obratiti paznju na postfiksni operator ++,
			      koji uvecava i tek nakon sto na starom indeksu
			      upise vrednost cifre */
      x /= 10;
    }
  while(x != 0);

  /* Nakon petlje, i ima upravo vrednost duzine niza, tj. broj cifara (jer je
     i u poslednjoj iteraciji i takodje postfiksno uvecano za 1). */

  /* Sada treba ici po svim indeksima niza u obrnutom poretku, sa desna na 
     levo (tj. pocev od indeksa i - 1 do indeksa 0, jer je i upravo duzina
     niza). Zato najpre i umanjimo za jedan, a onda prolazimo kroz petlju
     umanjujuci i dokle god ne postane negativno */
  for(i--; i >= 0; i--)
    printf("%d, ", cifre[i]);
  printf("\n");


  /* U slucaju da nam je duzina niza bila potrebna i za kasnije, morali
     bismo da uvedemo drugu promenljivu (npr. j) i da nju koristimo u
     gornjoj petlji za prolazak kroz niz:
     
     for(j = i - 1; j >=0; j--)
      printf("%d,  ", cifre[j]);

     Sada promenljiva i zadrzava vrednost duzine niza, koja moze naknadno biti 
     koriscena za ponovni prolazak kroz niz. 
*/


  return 0;
}    


 
