#include <stdio.h>

/* Funkcija za zamenu vrednosti dve celobrojne promenljive. 
   OVA FUNKCIJA JE NEISPRAVNA!! Problem je u tome sto se 
   argumenti u C-u prenose po vrednosti, pa ce se ovim 
   algoritmom zameniti vrednosti lokalnih parematara 
   funkcije, ali ne i vrednosti originalnih promenljivih. */
void swap(int x, int y)
{
  int t;

  /* Swap algoritam: koristi se pomocna promenljiva, kako bi
     se vrednost prve promenljive privremeno sacuvala i kasnije
     upisala u y */
  t = x;
  x = y;
  y = t;
  
}

/* Ispravna verzija funkcije za zamenu vrednosti promenljivih.
   Ova verzija koristi POKAZIVACE kao parametre. Ovi pokazivaci
   prilikom poziva prihvataju ADRESE originalnih promenljivih iz
   pozivajuce funkcije, pa se pomocu njih moze pristupiti
   originalnim podacima (i menjati ih). */
void swap2(int * px, int * py)
{
  int t;

  t = *px;    /* Ono na sta pokazuje px upisujemo u t */
  *px = *py;  /* Ono na sta pokazuje py upisujemo u lokaciju 
		 na koju pokazuje px */
  *py = t;    /* u lokaciju na koju pokazuje py upisujemo vrednost t */
}


int main()
{
  int x, y;
  

  /* PRIMER JEDNOSTAVNE UPOTREBE POKAZIVACA:
  
     Pokazivacka promenljiva se deklarise na sledeci nacin:

     int * p;   

     (deklaracije u C-u se obicno citaju sa desna u levo -- "p je pokazivac na
     int"). 

     Pokazivacka promenljiva moze sadrzati adresu bilo kog int-a. Vrednost 
     adrese nekog podatka se moze uzeti operatorom &:

     p  = &x;

     Operator & daje izraz tipa "pokazivac na T", gde je T tip podatka na koji
     se primenjuje. Vrednost izraza je upravo adresa podatka na koji je 
     operator & primenjen.

     Kada pokazivac sadrzi adresu neke promenljive, kazemo da pokazivac 
     "pokazuje na promenljivu". Nakon toga se pomocu pokazivaca moze 
     jednostavno pristupati podatku na koji on pokazuje, koristeci operator
     * (operator indirekcije ili dereferenciranja):

     *p = 3;
     printf("%d\n", *p);

     Primetimo da se izraz *p moze koristiti i sa leve i sa desne strane
     operatora dodele, tj. bukvalno zamenjuje sam podatak na koji pokazuje,
     a ne samo njegovu vrednost.

     Ako je p pokazivac na tip T, tada je izraz *p tipa T, a njegova vrednost
     je vrednost podatka na koji p pokazuje.

     Primetimo da vazi *&x == x, kao i &*p == p, tj. ova dva operatora se
     ponistavaju!!
  */

  /* Ucitavamo dva cela broja */
  scanf("%d %d", &x, &y);

  printf("Originalne vrednosti: %d %d\n", x, y);

  /* Pozivamo funkciju swap2() kojoj predajemo kao argumente POKAZIVACE na
     lokalne promenljive x i y funkcije main() */
  swap2(&x, &y);
  
  printf("Nakon zamene: %d %d\n", x, y);
  
  return 0;
}
