`include "fpu.v"

module test;

   real x, y, r;
   
   wire [63:0] xw;
   wire [63:0] yw;
   wire [63:0] rw;
   
   reg 	       e_in;
   reg [2:0]	       op_sel;

   wire 	       s, z;
   wire [31:0] 	       ri;
   
   
   assign xw = $realtobits(x);
   assign yw = $realtobits(y);
    
   always @(rw)
     r = $bitstoreal(rw);
   
   fpu _fpu(e_in, op_sel, xw, yw, rw, ri, s, z);
   
   initial
     begin
	$monitor($time, ": %b %b %f %f %f %b %b %d\n", e_in, op_sel, x, y, r, s, z, ri);
	
	x = 6.4;
	y = 7.1;
	op_sel = `FPU_ADD;
	#10 e_in = 1;
	#10 op_sel = `FPU_SUB;
	#10 op_sel = `FPU_MUL;
	#10 op_sel = `FPU_DIV;
	#10 op_sel = `FPU_RND;
	#10 op_sel = `FPU_CMP;
	
     end
        
endmodule
